// SystemInfoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FKAttendOcxSample.h"
#include "SystemInfoDlg.h"
#include "MainDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSystemInfoDlg dialog
extern CString ReturnResultPrint(long anResultCode);
extern long gnCommHandleIndex;

CSystemInfoDlg::CSystemInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSystemInfoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSystemInfoDlg)
	m_vnStatusValue = 0;
	m_strMessage = _T("");
	//}}AFX_DATA_INIT
	m_vbEnableDevice=false;
}


void CSystemInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSystemInfoDlg)
	DDX_Control(pDX, IDB_SETDEVICEINFO, m_cmdSetDeviceInfo);
	DDX_Control(pDX, IDB_GETDEVICEINFO, m_cmdGetDeviceInfo);
	DDX_Control(pDX, IDB_SETDEVICETIME, m_cmdSetDeviceTime);
	DDX_Control(pDX, IDB_DISABLE, m_cmdDisable);
	DDX_Control(pDX, IDB_GETDEVICETIME, m_cmdGetDeviceTime);
	DDX_Control(pDX, IDC_STATUS_COMBO, m_cmbStatus);
	DDX_Text(pDX, IDE_STATUSVALUE, m_vnStatusValue);
	DDX_Text(pDX, IDT_MESSAGE, m_strMessage);
	DDX_Control(pDX, IDB_GETDEVICESTATUS, m_cmdGetDeviceStaus);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSystemInfoDlg, CDialog)
	//{{AFX_MSG_MAP(CSystemInfoDlg)
	ON_BN_CLICKED(IDB_GETDEVICETIME, OnGetdevicetime)
	ON_BN_CLICKED(IDB_SETDEVICETIME, OnSetdevicetime)
	ON_BN_CLICKED(IDB_POWERON, OnPoweron)
	ON_BN_CLICKED(IDB_POWEROFF, OnPoweroff)
	ON_BN_CLICKED(IDB_DISABLE, OnDisable)
	ON_BN_CLICKED(IDB_GETDEVICEINFO, OnGetdeviceinfo)
	ON_BN_CLICKED(IDB_GETDEVICESTATUS, OnGetdevicestatus)
	ON_BN_CLICKED(IDB_SETDEVICEINFO, OnSetdeviceinfo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSystemInfoDlg message handlers
extern CMainDlg m_MainDlg;

void CSystemInfoDlg::OnGetdevicetime() 
{
	// TODO: Add your control notification handler code here	
	DATE vdwDate;
    CString strDataTime;
    long vnResultCode;

	m_cmdGetDeviceTime.EnableWindow(false);
	m_strMessage = "Working...";
	UpdateData(false);

	
    vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice(0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = "Working...";
		UpdateData(false);
		goto END;
	}

    vnResultCode = m_MainDlg.m_ctrlFkattend.GetDeviceTime(&vdwDate);
	
    if( vnResultCode == RUN_SUCCESS)
	{
		COleDateTime vOleDateTime(vdwDate);
		strDataTime.Format("Date=%04d%02d%02d, Time=%02dʱ%02d%02d", vOleDateTime.GetYear(),vOleDateTime.GetMonth(),vOleDateTime.GetDay(), 
			                                                                     vOleDateTime.GetHour(),vOleDateTime.GetMinute(),vOleDateTime.GetSecond());
        m_strMessage= strDataTime;
	}
    else	
        m_strMessage = ReturnResultPrint(vnResultCode);
	
END:
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice(1);
	m_cmdGetDeviceTime.EnableWindow(true);	
	UpdateData(false);
}

void CSystemInfoDlg::OnSetdevicetime() 
{
	// TODO: Add your control notification handler code here

	COleDateTime vOleDateTime;
	DATE vdwDate;
    CString strDataTime;
    long vnResultCode;

    m_cmdSetDeviceTime.EnableWindow(false);	
    m_strMessage = "Working...";
	UpdateData(false);
    vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice(0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdSetDeviceTime.EnableWindow(true);
        goto END;
    }

    vdwDate = vOleDateTime.GetCurrentTime();
    vnResultCode = m_MainDlg.m_ctrlFkattend.SetDeviceTime(vdwDate);
    m_strMessage = ReturnResultPrint(vnResultCode);
END:
    
	m_MainDlg.m_ctrlFkattend.EnableDevice(1);
    m_cmdSetDeviceTime.EnableWindow(true);
	UpdateData(false);
	
}

void CSystemInfoDlg::OnPoweron() 
{
	// TODO: Add your control notification handler code here
	m_MainDlg.m_ctrlFkattend.PowerOnAllDevice();
}

void CSystemInfoDlg::OnPoweroff() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;

    m_strMessage="Working...";	
	UpdateData(false);

    vnResultCode = m_MainDlg.m_ctrlFkattend.PowerOffDevice();
    m_strMessage = ReturnResultPrint(vnResultCode);	
}

void CSystemInfoDlg::OnDisable() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;
	m_vbEnableDevice = !m_vbEnableDevice;
	m_strMessage = "Working...";	
	UpdateData(false);

	if(m_vbEnableDevice == TRUE)
		m_cmdDisable.SetWindowText("Enable Device");
	else
		m_cmdDisable.SetWindowText("Disable Device");
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice(!m_vbEnableDevice);
	m_strMessage = ReturnResultPrint(vnResultCode);
	UpdateData(false);
}

void CSystemInfoDlg::OnGetdeviceinfo() 
{
	// TODO: Add your control notification handler code here
	long vnInfoIndex, vnSelIndex;
    long vnValue;
    long vnResultCode;
	CString vStr;

    m_cmdGetDeviceInfo.EnableWindow(false);
    m_strMessage = "Working...";
    UpdateData(false);

    vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice(0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdGetDeviceInfo.EnableWindow(true);
        goto END;
    }

	vStr.Empty();
	vnSelIndex = m_cmbStatus.GetCurSel();
	m_cmbStatus.GetLBText(vnSelIndex, vStr);
	vnInfoIndex=atol(vStr.operator LPCTSTR());

    if(vnInfoIndex == 11)
        vnInfoIndex = 24;
    
    vnResultCode = m_MainDlg.m_ctrlFkattend.GetDeviceInfo(vnInfoIndex, &vnValue);

    if( vnResultCode == RUN_SUCCESS )
	{
        switch(vnInfoIndex)
		{
            case DI_MANAGERS:
				m_strMessage.Format("ManagerCount = %d", vnValue);
				break;

            case DI_MACHINENUM:  
				m_strMessage.Format("Machine Num = %d", vnValue);
				break;

            case DI_LANGAUGE:  
				m_strMessage.Format("Language = %d", vnValue);
				break;

            case DI_POWEROFF_TIME:  
				m_strMessage.Format("PowerOffTime =  %d", vnValue);
				break;

            case DI_LOCK_CTRL:  
				m_strMessage.Format("LockOperate = %d",vnValue);
				break;

            case DI_GLOG_WARNING:
				m_strMessage.Format("GLogWarning = %d ", vnValue);
				break;

            case DI_SLOG_WARNING:
				m_strMessage.Format("SLogWarning = %d", vnValue);
				break;

            case DI_VERIFY_INTERVALS:
				m_strMessage.Format("ReVerifyTime = %d", vnValue);
				break;

            case DI_RSCOM_BPS:
				switch(vnValue)
				{
					case BPS_9600:
						m_strMessage.Format("Baudrate("" %d "") : ""9600", vnValue);
						break;

					case BPS_19200:
						m_strMessage.Format("Baudrate("" %d "") : ""19200", vnValue);
						break;

					case BPS_38400:
						m_strMessage.Format("Baudrate("" %d "") : ""38400", vnValue);
						break;

					case BPS_57600:
						m_strMessage.Format("Baudrate("" %d "") : ""57600", vnValue);
						break;

					case BPS_115200:
						m_strMessage.Format("Baudrate("" %d "") : ""115200", vnValue);
						break;

					default:
						m_strMessage.Format("Baudrate("" %d "") : ""--", vnValue);
						break;
				}                
                
				break;
                
            case DI_VERIFY_KIND:
				m_strMessage="VerifyKind = ";

				switch(vnValue)
				{
					case 0:
						m_strMessage+= " F / P / C";
						break;
					
					case 1:
						m_strMessage+= "F + P";
						break;
					
					case 2:
						m_strMessage+= "F + C";
						break;

					case 3 :
						m_strMessage+=  "C";
						break;
				}
				break;

            case DI_DATE_SEPARATE: 
				m_strMessage.Format("DateSeperate = %d", vnValue);
				break;

            default: 
				m_strMessage = "--";
				break;
        }
	}
    else
        m_strMessage = ReturnResultPrint(vnResultCode);
    

END:
    m_MainDlg.m_ctrlFkattend.EnableDevice(1);
    m_cmdGetDeviceInfo.EnableWindow(true);
	UpdateData(false);
}

void CSystemInfoDlg::OnGetdevicestatus() 
{
	// TODO: Add your control notification handler code here
	long vnStatusIndex, vnSelIndex;
    long vnValue;
    long vnResultCode;
	CString vStr;

    m_cmdGetDeviceStaus.EnableWindow(false);
    m_strMessage = "Working...";
	UpdateData(false);
    
    vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice(0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdGetDeviceStaus.EnableWindow(true);
        goto END;
    }

	vStr.Empty();
	vnSelIndex = m_cmbStatus.GetCurSel();
	m_cmbStatus.GetLBText(vnSelIndex, vStr);
	vnStatusIndex=atol(vStr.operator LPCTSTR());

    vnResultCode = m_MainDlg.m_ctrlFkattend.GetDeviceStatus(vnStatusIndex, &vnValue);
    if(vnResultCode == RUN_SUCCESS)
	{
        switch(vnStatusIndex)
		{
            case GET_MANAGERS:  
				m_strMessage.Format("Manager count = %d" , vnValue);
				break;
            case GET_USERS:  
				m_strMessage.Format("User count = %d", vnValue);
				break;
            case GET_FPS:
				m_strMessage.Format("Fp count = %d", vnValue);
				break;
            case GET_PSWS:
				m_strMessage.Format("Password count = %d", vnValue);
				break;
            case GET_SLOGS:  
				m_strMessage.Format("SLog count = %d",vnValue);
				break;
            case GET_GLOGS:  
				m_strMessage.Format("GLog count = %d", vnValue);
				break;
            case GET_ASLOGS:  
				m_strMessage.Format("All SLog count =%d ", vnValue);
				break;
            case GET_AGLOGS:  
				m_strMessage.Format("All GLog count = %d", vnValue);
				break;
            case GET_CARDS:  
				m_strMessage.Format("Card count = %d", vnValue);				
				break;
            default: 
				m_strMessage = "--";
				break;
		}
	}
    else
        m_strMessage = ReturnResultPrint(vnResultCode);
    
END:
    m_MainDlg.m_ctrlFkattend.EnableDevice (1);
    m_cmdGetDeviceStaus.EnableWindow(true);
	UpdateData(false);
}

void CSystemInfoDlg::OnSetdeviceinfo() 
{
	// TODO: Add your control notification handler code here
	long vnInfoIndex, vnSelIndex;
    long vnValue;
    long vnResultCode;
	CString vStr;

    UpdateData(true);
	m_cmdSetDeviceInfo.EnableWindow(false);
    m_strMessage = "Working...";
	UpdateData(false);

    vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice(0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdSetDeviceInfo.EnableWindow(true);
        goto END;
    }

    vStr.Empty();
	vnSelIndex = m_cmbStatus.GetCurSel();
	m_cmbStatus.GetLBText(vnSelIndex, vStr);
	vnInfoIndex=atol(vStr.operator LPCTSTR());

    vnValue = m_vnStatusValue;
    if(vnInfoIndex == 11)
        vnInfoIndex = 24;
    
    vnResultCode = m_MainDlg.m_ctrlFkattend.SetDeviceInfo(vnInfoIndex, vnValue);
	if (vnInfoIndex== DI_MACHINENUM && vnResultCode==RUN_SUCCESS)
	{
		CMainDlg*  vMainDlg;
		vMainDlg = (CMainDlg*)(AfxGetApp()->GetMainWnd());
		vMainDlg->m_vnMachineNumber=vnValue;
		vMainDlg->UpdateData(FALSE);		
	}
    m_strMessage = ReturnResultPrint(vnResultCode);
END:
    m_MainDlg.m_ctrlFkattend.EnableDevice(1);
    m_cmdSetDeviceInfo.EnableWindow(true);
	UpdateData(false);
}

BOOL CSystemInfoDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class	
	::ShowWindow(AfxGetApp()->GetMainWnd()->m_hWnd,SW_SHOW);
	return CDialog::DestroyWindow();
}

BOOL CSystemInfoDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	for(int i=0; i<12; i++)
	{
		CString vStr;
		vStr.Format("%d", i+1);
		m_cmbStatus.AddString(vStr);
	}
	m_cmbStatus.SetCurSel(0);
	
	return true;  // return true unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return false
}
