// RealTimeInfoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FKAttendDllSample.h"
#include "RealTimeInfoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRealTimeInfoDlg dialog
extern CString ReturnResultPrint(long anResultCode);
extern long gnCommHandleIndex;
int gDataLen=16;
#define MAX_REALTIME			4
typedef struct tagREALTIMEINFO
{
	BYTE Valid;
	BYTE AckTime;
	BYTE WaitTime;
	BYTE Reserve;
	long SendPos;
	BYTE Hour[MAX_REALTIME];
	BYTE Minute[MAX_REALTIME];
}REALTIMEINFO;


CRealTimeInfoDlg::CRealTimeInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRealTimeInfoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRealTimeInfoDlg)
	m_vnAckTime = 0;
	m_vnHour1 = 0;
	m_vnHour2 = 0;
	m_vnHour3 = 0;
	m_vnHour4 = 0;
	m_vnMinute1 = 0;
	m_vnMinute2 = 0;
	m_vnMinute3 = 0;
	m_vnMinute4 = 0;
	m_vnWaitTime = 0;
	m_strMessage = _T("Message");
	//}}AFX_DATA_INIT
	m_vnSelKind=0;
}


void CRealTimeInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRealTimeInfoDlg)
	DDX_Control(pDX, IDB_WRITE, m_cmdWrite);
	DDX_Control(pDX, IDB_READ, m_cmdRead);
	DDX_Text(pDX, IDE_ACKTIME, m_vnAckTime);
	DDX_Text(pDX, IDE_HOUR1, m_vnHour1);
	DDX_Text(pDX, IDE_HOUR2, m_vnHour2);
	DDX_Text(pDX, IDE_HOUR3, m_vnHour3);
	DDX_Text(pDX, IDE_HOUR4, m_vnHour4);
	DDX_Text(pDX, IDE_MINUTE1, m_vnMinute1);
	DDX_Text(pDX, IDE_MINUTE2, m_vnMinute2);
	DDX_Text(pDX, IDE_MINUTE3, m_vnMinute3);
	DDX_Text(pDX, IDE_MINUTE4, m_vnMinute4);
	DDX_Text(pDX, IDE_WAITTIME, m_vnWaitTime);
	DDX_Text(pDX, IDT_MESSAGE, m_strMessage);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRealTimeInfoDlg, CDialog)
	//{{AFX_MSG_MAP(CRealTimeInfoDlg)
	ON_BN_CLICKED(IDR_SETWAITTIME, OnSetwaittime)
	ON_BN_CLICKED(IDR_TIMEZONE, OnTimezone)
	ON_BN_CLICKED(IDB_READ, OnRead)
	ON_BN_CLICKED(IDB_WRITE, OnWrite)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRealTimeInfoDlg message handlers

BOOL CRealTimeInfoDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	::ShowWindow(AfxGetApp()->GetMainWnd()->m_hWnd,SW_SHOW);
	return CDialog::DestroyWindow();
}

BOOL CRealTimeInfoDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	OnSetwaittime();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CRealTimeInfoDlg::OwnerEnableItems(long anKind)
{

	CButton* pButton;

	GetDlgItem(IDG_FRAME0)->EnableWindow(FALSE);
	GetDlgItem(IDT_ACKTIME)->EnableWindow(FALSE);
	GetDlgItem(IDT_ACKTIME1)->EnableWindow(FALSE);
	GetDlgItem(IDT_WAITTIME)->EnableWindow(FALSE);
	GetDlgItem(IDT_WAITTIME1)->EnableWindow(FALSE);
	GetDlgItem(IDE_ACKTIME)->EnableWindow(FALSE);
	GetDlgItem(IDE_WAITTIME)->EnableWindow(FALSE);

	GetDlgItem(IDG_FRAME1)->EnableWindow(FALSE);
	GetDlgItem(IDT_SH)->EnableWindow(FALSE);
	GetDlgItem(IDT_SM)->EnableWindow(FALSE);
	GetDlgItem(IDT_T1)->EnableWindow(FALSE);
	GetDlgItem(IDT_T2)->EnableWindow(FALSE);
	GetDlgItem(IDT_T3)->EnableWindow(FALSE);
	GetDlgItem(IDT_T4)->EnableWindow(FALSE);
	GetDlgItem(IDT_M1)->EnableWindow(FALSE);
	GetDlgItem(IDT_M2)->EnableWindow(FALSE);
	GetDlgItem(IDT_M3)->EnableWindow(FALSE);
	GetDlgItem(IDT_M4)->EnableWindow(FALSE);
	GetDlgItem(IDE_HOUR1)->EnableWindow(FALSE);
	GetDlgItem(IDE_HOUR2)->EnableWindow(FALSE);
	GetDlgItem(IDE_HOUR3)->EnableWindow(FALSE);
	GetDlgItem(IDE_HOUR4)->EnableWindow(FALSE);
	GetDlgItem(IDE_MINUTE1)->EnableWindow(FALSE);
	GetDlgItem(IDE_MINUTE2)->EnableWindow(FALSE);
	GetDlgItem(IDE_MINUTE3)->EnableWindow(FALSE);
	GetDlgItem(IDE_MINUTE4)->EnableWindow(FALSE);

	switch (anKind)
	{
	case 1:

		pButton = (CButton*)GetDlgItem(IDR_SETWAITTIME);	
		pButton->SetCheck(1);		
		pButton = (CButton*)GetDlgItem(IDR_TIMEZONE);	
		pButton->SetCheck(0);

		GetDlgItem(IDT_ACKTIME)->EnableWindow(TRUE);
		GetDlgItem(IDT_ACKTIME1)->EnableWindow(TRUE);
		GetDlgItem(IDT_WAITTIME)->EnableWindow(TRUE);
		GetDlgItem(IDT_WAITTIME1)->EnableWindow(TRUE);
		GetDlgItem(IDE_ACKTIME)->EnableWindow(TRUE);
		GetDlgItem(IDE_WAITTIME)->EnableWindow(TRUE);
		m_vnSelKind=1;
		break;

	case 2:
		pButton = (CButton*)GetDlgItem(IDR_TIMEZONE);
		pButton->SetCheck(1);
		pButton = (CButton*)GetDlgItem(IDR_SETWAITTIME);		
		pButton->SetCheck(0);

		GetDlgItem(IDT_SH)->EnableWindow(TRUE);
		GetDlgItem(IDT_SM)->EnableWindow(TRUE);
		GetDlgItem(IDT_T1)->EnableWindow(TRUE);
		GetDlgItem(IDT_T2)->EnableWindow(TRUE);
		GetDlgItem(IDT_T3)->EnableWindow(TRUE);
		GetDlgItem(IDT_T4)->EnableWindow(TRUE);
		GetDlgItem(IDT_M1)->EnableWindow(TRUE);
		GetDlgItem(IDT_M2)->EnableWindow(TRUE);
		GetDlgItem(IDT_M3)->EnableWindow(TRUE);
		GetDlgItem(IDT_M4)->EnableWindow(TRUE);
		GetDlgItem(IDE_HOUR1)->EnableWindow(TRUE);
		GetDlgItem(IDE_HOUR2)->EnableWindow(TRUE);
		GetDlgItem(IDE_HOUR3)->EnableWindow(TRUE);
		GetDlgItem(IDE_HOUR4)->EnableWindow(TRUE);
		GetDlgItem(IDE_MINUTE1)->EnableWindow(TRUE);
		GetDlgItem(IDE_MINUTE2)->EnableWindow(TRUE);
		GetDlgItem(IDE_MINUTE3)->EnableWindow(TRUE);
		GetDlgItem(IDE_MINUTE4)->EnableWindow(TRUE);
		m_vnSelKind=2;
		break;
	}

	UpdateData(false);

}

void CRealTimeInfoDlg::OnSetwaittime() 
{
	// TODO: Add your control notification handler code here	
	OwnerEnableItems(1);
}

void CRealTimeInfoDlg::OnTimezone() 
{
	// TODO: Add your control notification handler code here
	OwnerEnableItems(2);
}


void CRealTimeInfoDlg::OnRead() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode; 
	long gOptionFlag;
	REALTIMEINFO vsRealInfo;
	long vpRealInfo[4];
	
	m_cmdRead.EnableWindow(FALSE);
	m_strMessage = "Working...";
	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if (vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdRead.EnableWindow(TRUE);
		goto END;
	}
	
	vnResultCode = FK_GetRealTimeInfo(gnCommHandleIndex,&vpRealInfo[0]);
	m_strMessage = ReturnResultPrint(vnResultCode);
	if (vnResultCode = RUN_SUCCESS)
	{

		ZeroMemory(&vsRealInfo, sizeof(REALTIMEINFO));
		CopyMemory(&vsRealInfo, vpRealInfo, gDataLen);
		
		m_vnHour1 = vsRealInfo.Hour[0];
		m_vnHour2 = vsRealInfo.Hour[1];
		m_vnHour3 = vsRealInfo.Hour[2];
		m_vnHour4 = vsRealInfo.Hour[3];
		m_vnMinute1 = vsRealInfo.Minute[0];
		m_vnMinute2 = vsRealInfo.Minute[1];
		m_vnMinute3 = vsRealInfo.Minute[2];
		m_vnMinute4 = vsRealInfo.Minute[3];
	}
	m_vnAckTime = vsRealInfo.AckTime;
	m_vnWaitTime = vsRealInfo.WaitTime;
	gOptionFlag = vsRealInfo.Valid;

	if( gOptionFlag == 0 )
		gOptionFlag = 1;
	OwnerEnableItems (gOptionFlag );

END:
	FK_EnableDevice(gnCommHandleIndex, 1) ;
	m_cmdRead.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CRealTimeInfoDlg::OnWrite() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode; 
	REALTIMEINFO vsRealInfo;
	long vpRealInfo[4];
	
	UpdateData(TRUE);
	m_cmdWrite.EnableWindow(FALSE);
	m_strMessage = "Working...";

	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if (vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdWrite.EnableWindow(TRUE);
		goto END;
	}
	
	ZeroMemory(&vsRealInfo, sizeof(REALTIMEINFO));		
	vsRealInfo.Hour[0]=(BYTE)m_vnHour1;
	vsRealInfo.Hour[1]=(BYTE)m_vnHour2;
	vsRealInfo.Hour[2]=(BYTE)m_vnHour3;
	vsRealInfo.Hour[3]=(BYTE)m_vnHour4;
	vsRealInfo.Minute[0]=(BYTE)m_vnMinute1;
	vsRealInfo.Minute[1]=(BYTE)m_vnMinute2 ;
	vsRealInfo.Minute[2]=(BYTE)m_vnMinute3;
	vsRealInfo.Minute[3]=(BYTE)m_vnMinute4 ;

	vsRealInfo.AckTime=(BYTE)m_vnAckTime;
	vsRealInfo.WaitTime= (BYTE)m_vnWaitTime ;
	vsRealInfo.Valid=(BYTE)m_vnSelKind;
	CopyMemory(vpRealInfo, &vsRealInfo, gDataLen);
	
	vnResultCode = FK_SetRealTimeInfo(gnCommHandleIndex,&vpRealInfo[0]);
	m_strMessage = ReturnResultPrint(vnResultCode);
END:
	FK_EnableDevice(gnCommHandleIndex, 1) ;
	m_cmdWrite.EnableWindow(TRUE);
	UpdateData(FALSE);
	
}
