// PasstimeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FKAttendDllSample.h"
#include "FKDefine.h"
#include "PasstimeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPasstimeDlg dialog
#define MAX_PASSCTRLGROUP_COUNT		50
#define MAX_PASSCTRL_COUNT			7
//--- Pass Control Time ---
typedef struct tagPASSTIMEINFO
{
	BYTE StartHour;
	BYTE StartMinute;
	BYTE EndHour;
	BYTE EndMinute;
}PASSTIMEINFO; //'4byte

//--- Pass Control Time Infomation ---
typedef struct tagPASSCTRLTIMEINFO
{
	PASSTIMEINFO mPassCtrlTime[MAX_PASSCTRL_COUNT];
}PASSCTRLTIMEINFO; //28byte

#define MAX_USERPASSINFO_COUNT		3
typedef struct tagUSERPASSTIMEINFO
{
	BYTE UserPassID[MAX_USERPASSINFO_COUNT];
}USERPASSTIMEINFO; // 3byte

#define MAX_GROUPPASSKIND_COUNT		5
#define MAX_GROUPPASSINFO_COUNT		3

typedef struct tagGROUPPASSTIMEINFO
{
	BYTE GroupPassID[MAX_GROUPPASSINFO_COUNT];
}GROUPPASSTIMEINFO; //3byte

#define MAX_GROUPMATCHINFO_COUNT	10
typedef struct tagGROUPMATCHINFO0
{
	int GroupMatch[MAX_GROUPMATCHINFO_COUNT];
}GROUPMATCHINFO0; //20byte

//=============== Door Status ===============//
#define DOOR_CONROLRESET	0
#define DOOR_OPEND			1
#define DOOR_CLOSED			2
#define DOOR_COMMNAD		3


///////////////////////////////////////////////////////////////
#define DATALEN					28
extern CString ReturnResultPrint(long anResultCode);
extern long gnCommHandleIndex;

CPasstimeDlg::CPasstimeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPasstimeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPasstimeDlg)
	m_strMessage = _T("Message");
	m_vnEh1 = 0;
	m_vnEh2 = 0;
	m_vnEh3 = 0;
	m_vnEh4 = 0;
	m_vnEh5 = 0;
	m_vnEh6 = 0;
	m_vnEh7 = 0;
	m_vnEm1 = 0;
	m_vnEm2 = 0;
	m_vnEm3 = 0;
	m_vnEm4 = 0;
	m_vnEm5 = 0;
	m_vnEm6 = 0;
	m_vnEm7 = 0;
	m_vnGroupID = 1;
	m_vnGTz1 = 0;
	m_vnGTz2 = 0;
	m_vnGTz3 = 0;
	m_vnSh1 = 0;
	m_vnSh2 = 0;
	m_vnSh3 = 0;
	m_vnSh4 = 0;
	m_vnSh5 = 0;
	m_vnSh6 = 0;
	m_vnSh7 = 0;
	m_vnSm1 = 0;
	m_vnSm2 = 0;
	m_vnSm3 = 0;
	m_vnSm4 = 0;
	m_vnSm5 = 0;
	m_vnSm6 = 0;
	m_vnSm7 = 0;
	m_vnTz = 1;
	m_vnUg1 = 0;
	m_vnUg10 = 0;
	m_vnUg2 = 0;
	m_vnUg3 = 0;
	m_vnUg4 = 0;
	m_vnUg5 = 0;
	m_vnUg6 = 0;
	m_vnUg7 = 0;
	m_vnUg8 = 0;
	m_vnUg9 = 0;
	m_vnUserGroupID = 1;
	m_vnUserID = 1;
	m_vnUTz1 = 0;
	m_vnUTz2 = 0;
	m_vnUTz3 = 0;
	//}}AFX_DATA_INIT
}


void CPasstimeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPasstimeDlg)
	DDX_Control(pDX, IDB_TZWRITE, m_cmdTzWrite);
	DDX_Control(pDX, IDB_TZREAD, m_cmdTzRead);
	DDX_Control(pDX, IDB_SETUSER, m_cmdSetUser);
	DDX_Control(pDX, IDB_SETMATCH, m_cmdSetMatch);
	DDX_Control(pDX, IDB_SETGROUP, m_cmdSetGroup);
	DDX_Control(pDX, IDB_SETDOORSTATE, m_cmdSetDoorState);
	DDX_Control(pDX, IDB_GETUSER, m_cmdGetUser);
	DDX_Control(pDX, IDB_GETMATCH, m_cmdGetMatch);
	DDX_Control(pDX, IDB_GETGROUP, m_cmdGetGroup);
	DDX_Control(pDX, IDB_GETDOORSTATE, m_cmdGetDoorState);
	DDX_Control(pDX, IDC_DOORSTATE_COMBO, m_cmbDoorState);
	DDX_Text(pDX, IDT_MESSAGE, m_strMessage);
	DDX_Text(pDX, IDE_EH1, m_vnEh1);
	DDX_Text(pDX, IDE_EH2, m_vnEh2);
	DDX_Text(pDX, IDE_EH3, m_vnEh3);
	DDX_Text(pDX, IDE_EH4, m_vnEh4);
	DDX_Text(pDX, IDE_EH5, m_vnEh5);
	DDX_Text(pDX, IDE_EH6, m_vnEh6);
	DDX_Text(pDX, IDE_EH7, m_vnEh7);
	DDX_Text(pDX, IDE_EM1, m_vnEm1);
	DDX_Text(pDX, IDE_EM2, m_vnEm2);
	DDX_Text(pDX, IDE_EM3, m_vnEm3);
	DDX_Text(pDX, IDE_EM4, m_vnEm4);
	DDX_Text(pDX, IDE_EM5, m_vnEm5);
	DDX_Text(pDX, IDE_EM6, m_vnEm6);
	DDX_Text(pDX, IDE_EM7, m_vnEm7);
	DDX_Text(pDX, IDE_GROUPID, m_vnGroupID);
	DDX_Text(pDX, IDE_GTZ1, m_vnGTz1);
	DDX_Text(pDX, IDE_GTZ2, m_vnGTz2);
	DDX_Text(pDX, IDE_GTZ3, m_vnGTz3);
	DDX_Text(pDX, IDE_SH1, m_vnSh1);
	DDX_Text(pDX, IDE_SH2, m_vnSh2);
	DDX_Text(pDX, IDE_SH3, m_vnSh3);
	DDX_Text(pDX, IDE_SH4, m_vnSh4);
	DDX_Text(pDX, IDE_SH5, m_vnSh5);
	DDX_Text(pDX, IDE_SH6, m_vnSh6);
	DDX_Text(pDX, IDE_SH7, m_vnSh7);
	DDX_Text(pDX, IDE_SM1, m_vnSm1);
	DDX_Text(pDX, IDE_SM2, m_vnSm2);
	DDX_Text(pDX, IDE_SM3, m_vnSm3);
	DDX_Text(pDX, IDE_SM4, m_vnSm4);
	DDX_Text(pDX, IDE_SM5, m_vnSm5);
	DDX_Text(pDX, IDE_SM6, m_vnSm6);
	DDX_Text(pDX, IDE_SM7, m_vnSm7);
	DDX_Text(pDX, IDE_TZ, m_vnTz);
	DDX_Text(pDX, IDE_UG1, m_vnUg1);
	DDX_Text(pDX, IDE_UG10, m_vnUg10);
	DDX_Text(pDX, IDE_UG2, m_vnUg2);
	DDX_Text(pDX, IDE_UG3, m_vnUg3);
	DDX_Text(pDX, IDE_UG4, m_vnUg4);
	DDX_Text(pDX, IDE_UG5, m_vnUg5);
	DDX_Text(pDX, IDE_UG6, m_vnUg6);
	DDX_Text(pDX, IDE_UG7, m_vnUg7);
	DDX_Text(pDX, IDE_UG8, m_vnUg8);
	DDX_Text(pDX, IDE_UG9, m_vnUg9);
	DDX_Text(pDX, IDE_USERGROUPID, m_vnUserGroupID);
	DDX_Text(pDX, IDE_USERID, m_vnUserID);
	DDX_Text(pDX, IDE_UTZ1, m_vnUTz1);
	DDX_Text(pDX, IDE_UTZ2, m_vnUTz2);
	DDX_Text(pDX, IDE_UTZ3, m_vnUTz3);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPasstimeDlg, CDialog)
	//{{AFX_MSG_MAP(CPasstimeDlg)
	ON_BN_CLICKED(IDB_GETUSER, OnGetuser)
	ON_BN_CLICKED(IDB_SETUSER, OnSetuser)
	ON_BN_CLICKED(IDB_GETGROUP, OnGetgroup)
	ON_BN_CLICKED(IDB_SETGROUP, OnSetgroup)
	ON_BN_CLICKED(IDB_GETMATCH, OnGetmatch)
	ON_BN_CLICKED(IDB_SETMATCH, OnSetmatch)
	ON_BN_CLICKED(IDB_SETDOORSTATE, OnSetdoorstate)
	ON_BN_CLICKED(IDB_GETDOORSTATE, OnGetdoorstate)
	ON_BN_CLICKED(IDB_TZREAD, OnTzread)
	ON_BN_CLICKED(IDB_TZWRITE, OnTzwrite)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPasstimeDlg message handlers

BOOL CPasstimeDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	::ShowWindow(AfxGetApp()->GetMainWnd()->m_hWnd,SW_SHOW);
	return CDialog::DestroyWindow();
}

BOOL CPasstimeDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_cmbDoorState.AddString("Reset");
	m_cmbDoorState.AddString("Open");
	m_cmbDoorState.AddString("Close");
	m_cmbDoorState.AddString("Open..Close");
	m_cmbDoorState.SetCurSel(1);	
		
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPasstimeDlg::OnGetuser() 
{
	// TODO: Add your control notification handler code here
	long vEnrollNumber=0;
	long vGroupID=0;
	long vnResultCode;
	long mlngTmpBuff[DATALEN];
	USERPASSTIMEINFO mUserPassInfo;
	
	m_cmdGetUser.EnableWindow(FALSE);
	
	MULTIPROC();
	
	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if( vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdGetUser.EnableWindow(TRUE);
		goto END;
	}
	
	UpdateData(TRUE);
	vEnrollNumber = m_vnUserID;
	m_strMessage = "Getting...";
	UpdateData(FALSE);
	vnResultCode = FK_GetUserPassTime(gnCommHandleIndex, vEnrollNumber, &vGroupID, &mlngTmpBuff[0], DATALEN);
	if (vnResultCode == RUN_SUCCESS)
	{
		m_vnUserGroupID = vGroupID;
		m_strMessage = "GetUser Success!";		
		ZeroMemory(&mUserPassInfo, sizeof(USERPASSTIMEINFO));
		CopyMemory(&mUserPassInfo, &mlngTmpBuff[0], DATALEN) ;
		m_vnUTz1=mUserPassInfo.UserPassID[0];
		m_vnUTz2=mUserPassInfo.UserPassID[1];
		m_vnUTz3=mUserPassInfo.UserPassID[2];
	}
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
END:
	FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdGetUser.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CPasstimeDlg::OnSetuser() 
{
	// TODO: Add your control notification handler code here
	long vEnrollNumber=0;
	long vGroupID=0;
	long vnResultCode;
	long mlngTmpBuff[DATALEN];
	USERPASSTIMEINFO mUserPassInfo;
	
	m_cmdSetUser.EnableWindow(FALSE);	
	MULTIPROC();

	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if( vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdSetUser.EnableWindow(TRUE);
		goto END;
	}

	UpdateData(TRUE);
	vEnrollNumber = m_vnUserID;	
	vGroupID=m_vnUserGroupID;
	ZeroMemory(&mUserPassInfo, sizeof(USERPASSTIMEINFO));
	ZeroMemory(&mlngTmpBuff[0], DATALEN);
	mUserPassInfo.UserPassID[0]=(BYTE)m_vnUTz1;
	mUserPassInfo.UserPassID[1]=(BYTE)m_vnUTz2;
	mUserPassInfo.UserPassID[2]=(BYTE)m_vnUTz3;
	CopyMemory(&mlngTmpBuff[0], &mUserPassInfo, DATALEN);
	m_strMessage = "Getting...";
	UpdateData(FALSE);
	vnResultCode = FK_SetUserPassTime(gnCommHandleIndex, vEnrollNumber, vGroupID, &mlngTmpBuff[0], DATALEN);
	if (vnResultCode == RUN_SUCCESS)	
		m_strMessage = "SetUser Success!";	
	else
		m_strMessage = ReturnResultPrint(vnResultCode);

END:
	FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdSetUser.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CPasstimeDlg::OnGetgroup() 
{
	// TODO: Add your control notification handler code here
	long vEnrollNumber=0;
	long vGroupID=0;
	long vnResultCode;
	long mlngTmpBuff[DATALEN];
	GROUPPASSINFO mGroupPassInfo;
	
	m_cmdGetGroup.EnableWindow(FALSE);	
	MULTIPROC();
	
	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if( vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdGetGroup.EnableWindow(TRUE);
		goto END;
	}

	UpdateData(TRUE);
	vGroupID=m_vnUserGroupID;
	m_strMessage = "Getting...";
	UpdateData(FALSE);
	vnResultCode = FK_GetGroupPassTime(gnCommHandleIndex, vGroupID, &mlngTmpBuff[0], sizeof(GROUPPASSINFO));
	if (vnResultCode == RUN_SUCCESS)
	{
		
		m_strMessage = "GetUser Success!";		
		ZeroMemory(&mGroupPassInfo, sizeof(GROUPPASSINFO));
		CopyMemory(&mGroupPassInfo, &mlngTmpBuff[0], sizeof(GROUPPASSINFO)) ;
		m_vnGTz1=mGroupPassInfo.GroupPassID[0];
		m_vnGTz2=mGroupPassInfo.GroupPassID[1];
		m_vnGTz3=mGroupPassInfo.GroupPassID[2];
	}
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
END:
	FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdGetGroup.EnableWindow(TRUE);
	UpdateData(FALSE);	
}

void CPasstimeDlg::OnSetgroup() 
{
	// TODO: Add your control notification handler code here
	long vEnrollNumber=0;
	long vGroupID=0;
	long vnResultCode;
	long mlngTmpBuff[DATALEN];
	GROUPPASSINFO mGroupPassInfo;
	
	m_cmdSetGroup.EnableWindow(FALSE);	
	MULTIPROC();
	
	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if( vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdSetGroup.EnableWindow(TRUE);
		goto END;
	}
	
	UpdateData(TRUE);
	vGroupID=m_vnUserGroupID;
	ZeroMemory(&mGroupPassInfo, sizeof(GROUPPASSINFO));	
	mGroupPassInfo.GroupPassID[0]=(BYTE)m_vnGTz1;
	mGroupPassInfo.GroupPassID[1]=(BYTE)m_vnGTz2;
	mGroupPassInfo.GroupPassID[2]=(BYTE)m_vnGTz3;
	CopyMemory(&mlngTmpBuff[0], &mGroupPassInfo, sizeof(GROUPPASSINFO)) ;

	m_strMessage = "Getting...";
	UpdateData(FALSE);
	vnResultCode = FK_SetGroupPassTime(gnCommHandleIndex, vGroupID, &mlngTmpBuff[0], sizeof(GROUPPASSINFO));
	if (vnResultCode == RUN_SUCCESS)	
		m_strMessage = "SetUser Success!";	
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
END:
	FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdSetGroup.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CPasstimeDlg::OnGetmatch() 
{
	// TODO: Add your control notification handler code here
    long vnResultCode;
	tagGROUPMATCHINFO0 mGroupMatchInfo;
	long* mlngTmpBuff;
		
	m_cmdGetMatch.EnableWindow(FALSE);
	m_strMessage = "Getting...";
	UpdateData(FALSE);
	MULTIPROC();

	
	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdGetMatch.EnableWindow(FALSE);
		goto END;
	}

	mlngTmpBuff=new long [sizeof(tagGROUPMATCHINFO0)];
	memset(mlngTmpBuff,0, sizeof(tagGROUPMATCHINFO0));
	
	vnResultCode = FK_GetGroupMatch(gnCommHandleIndex, &mlngTmpBuff[0], sizeof(tagGROUPMATCHINFO0));
	if (vnResultCode == RUN_SUCCESS)
	{
		m_strMessage = "Success!";
		ZeroMemory(&mGroupMatchInfo, sizeof(tagGROUPMATCHINFO0));
		CopyMemory(&mGroupMatchInfo, &mlngTmpBuff[0], sizeof(tagGROUPMATCHINFO0)) ;
		//ShowValue
		m_vnUg1=mGroupMatchInfo.GroupMatch[0];
		m_vnUg2=mGroupMatchInfo.GroupMatch[1];
		m_vnUg3=mGroupMatchInfo.GroupMatch[2];
		m_vnUg4=mGroupMatchInfo.GroupMatch[3];
		m_vnUg5=mGroupMatchInfo.GroupMatch[4];
		m_vnUg6=mGroupMatchInfo.GroupMatch[5];
		m_vnUg7=mGroupMatchInfo.GroupMatch[6];
		m_vnUg8=mGroupMatchInfo.GroupMatch[7];
		m_vnUg9=mGroupMatchInfo.GroupMatch[8];
		m_vnUg10=mGroupMatchInfo.GroupMatch[9];
	}
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
END:

	delete mlngTmpBuff;
	FK_EnableDevice (gnCommHandleIndex, 1);
	m_cmdGetMatch.EnableWindow(TRUE);
	UpdateData(FALSE);
    
}

void CPasstimeDlg::OnSetmatch() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;
	tagGROUPMATCHINFO0 mGroupMatchInfo;
	long* mlngTmpBuff;
	
	m_cmdSetMatch.EnableWindow(FALSE);
	MULTIPROC();
	
	
	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdSetMatch.EnableWindow(FALSE);
		goto END;
	}
	
	mlngTmpBuff=new long [sizeof(tagGROUPMATCHINFO0)];
	memset(mlngTmpBuff,0, sizeof(tagGROUPMATCHINFO0));
	ZeroMemory(&mGroupMatchInfo, sizeof(tagGROUPMATCHINFO0));		
	//GetValue
	UpdateData(TRUE);
	mGroupMatchInfo.GroupMatch[0]=m_vnUg1;
	mGroupMatchInfo.GroupMatch[1]=m_vnUg2;
	mGroupMatchInfo.GroupMatch[2]=m_vnUg3;
	mGroupMatchInfo.GroupMatch[3]=m_vnUg4;
	mGroupMatchInfo.GroupMatch[4]=m_vnUg5;
	mGroupMatchInfo.GroupMatch[5]=m_vnUg6;
	mGroupMatchInfo.GroupMatch[6]=m_vnUg7;
	mGroupMatchInfo.GroupMatch[7]=m_vnUg8;
	mGroupMatchInfo.GroupMatch[8]=m_vnUg9;
	mGroupMatchInfo.GroupMatch[9]=m_vnUg10;
	CopyMemory(&mlngTmpBuff[0], &mGroupMatchInfo,  sizeof(tagGROUPMATCHINFO0)) ;

	m_strMessage = "Getting...";
	UpdateData(FALSE);
	vnResultCode = FK_SetGroupMatch(gnCommHandleIndex, &mlngTmpBuff[0], sizeof(tagGROUPMATCHINFO0));
	if (vnResultCode == RUN_SUCCESS)	
		m_strMessage = "Success!";
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
END:
	
	delete mlngTmpBuff;
	FK_EnableDevice (gnCommHandleIndex, 1);
	m_cmdSetMatch.EnableWindow(TRUE);
	UpdateData(FALSE);
}


void CPasstimeDlg::OnGetdoorstate() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;
	long vnState;
		
	m_cmdGetDoorState.EnableWindow(FALSE);
	m_strMessage = "Getting Door State...";
	UpdateData(FALSE);
	MULTIPROC();
	
	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if (vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdGetDoorState.EnableWindow(TRUE);
		goto END;
	}
	vnResultCode = FK_GetDoorStatus(gnCommHandleIndex, &vnState);
	
    if (vnResultCode == RUN_SUCCESS)
    {
		 if(vnState == DOOR_CONROLRESET)			 
			 m_strMessage = "State Reset!";		 
		 else if(vnState == DOOR_OPEND)
			m_strMessage = "Door Open!";
		else if(vnState == DOOR_CLOSED)
			m_strMessage = "Door Close!";
		else if (vnState == DOOR_COMMNAD)
			m_strMessage = "Command Open... Door Close!";
		else
			m_strMessage = "Door - Unknown!";
	}
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
		
END:
	FK_EnableDevice (gnCommHandleIndex, 1);
    m_cmdGetDoorState.EnableWindow(TRUE);
	UpdateData(FALSE);
}


void CPasstimeDlg::OnSetdoorstate() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;
	long vnState;
		
	m_cmdSetDoorState.EnableWindow(FALSE);
	m_strMessage = "Setting Door ...";
	MULTIPROC();
	
	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if( vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdSetDoorState.EnableWindow(TRUE);
		goto END;

	}
	
	switch (m_cmbDoorState.GetCurSel())
	{
		case 0:
			vnState = DOOR_CONROLRESET;
		break;

		case 1:
			vnState = DOOR_OPEND;
		break;

		case 2:
			vnState = DOOR_CLOSED;
		break;

		case 3:
			vnState = DOOR_COMMNAD;
		break;
	}

	vnResultCode = FK_SetDoorStatus(gnCommHandleIndex, vnState);
	if(vnResultCode == RUN_SUCCESS)
		m_strMessage = "Success!";
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
	

END:
	FK_EnableDevice (gnCommHandleIndex, 1);
    m_cmdSetDoorState.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CPasstimeDlg::OnTzread() 
{
	// TODO: Add your control notification handler code here
	long vnPassTimeID;
	long vnResultCode;

	PASSCTRLTIMEINFO vPassCtrlTime;
	long mlngTmpBuff[DATALEN];
		
	m_cmdTzRead.EnableWindow(FALSE);
	m_strMessage= "Reading...";
	UpdateData(FALSE);
	MULTIPROC();

	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdTzRead.EnableWindow(TRUE);
		goto END;
	}
		
	vnPassTimeID = 1;
	if(m_vnTz>=1)	
		vnPassTimeID=m_vnTz;	
	
	if(vnPassTimeID < 1 || vnPassTimeID > 50)
		vnPassTimeID = 1;
	
	
	vnResultCode = FK_GetPassTime(gnCommHandleIndex, vnPassTimeID, &mlngTmpBuff[0], sizeof(PASSCTRLTIMEINFO));
	if(vnResultCode == RUN_SUCCESS)
	{
		m_strMessage = "Success!";
		ZeroMemory(&vPassCtrlTime, sizeof(PASSCTRLTIMEINFO));
		CopyMemory(&vPassCtrlTime, &mlngTmpBuff[0], sizeof(PASSCTRLTIMEINFO));
		m_vnSh1=vPassCtrlTime.mPassCtrlTime[0].StartHour;	m_vnSm1=vPassCtrlTime.mPassCtrlTime[0].StartMinute;
		m_vnSh2=vPassCtrlTime.mPassCtrlTime[1].StartHour;	m_vnSm2=vPassCtrlTime.mPassCtrlTime[1].StartMinute;
		m_vnSh3=vPassCtrlTime.mPassCtrlTime[2].StartHour;	m_vnSm3=vPassCtrlTime.mPassCtrlTime[2].StartMinute;
		m_vnSh4=vPassCtrlTime.mPassCtrlTime[3].StartHour;	m_vnSm4=vPassCtrlTime.mPassCtrlTime[3].StartMinute;
		m_vnSh5=vPassCtrlTime.mPassCtrlTime[4].StartHour;	m_vnSm5=vPassCtrlTime.mPassCtrlTime[4].StartMinute;
		m_vnSh6=vPassCtrlTime.mPassCtrlTime[5].StartHour;	m_vnSm6=vPassCtrlTime.mPassCtrlTime[5].StartMinute;
		m_vnSh7=vPassCtrlTime.mPassCtrlTime[6].StartHour;	m_vnSm7=vPassCtrlTime.mPassCtrlTime[6].StartMinute;

		m_vnEh1=vPassCtrlTime.mPassCtrlTime[0].EndHour;	m_vnEm1=vPassCtrlTime.mPassCtrlTime[0].EndMinute;
		m_vnEh2=vPassCtrlTime.mPassCtrlTime[1].EndHour;	m_vnEm2=vPassCtrlTime.mPassCtrlTime[1].EndMinute;
		m_vnEh3=vPassCtrlTime.mPassCtrlTime[2].EndHour;	m_vnEm3=vPassCtrlTime.mPassCtrlTime[2].EndMinute;
		m_vnEh4=vPassCtrlTime.mPassCtrlTime[3].EndHour;	m_vnEm4=vPassCtrlTime.mPassCtrlTime[3].EndMinute;
		m_vnEh5=vPassCtrlTime.mPassCtrlTime[4].EndHour;	m_vnEm5=vPassCtrlTime.mPassCtrlTime[4].EndMinute;
		m_vnEh6=vPassCtrlTime.mPassCtrlTime[5].EndHour;	m_vnEm6=vPassCtrlTime.mPassCtrlTime[5].EndMinute;
		m_vnEh7=vPassCtrlTime.mPassCtrlTime[6].EndHour;	m_vnEm7=vPassCtrlTime.mPassCtrlTime[6].EndMinute;

	}
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
	

END:
	FK_EnableDevice (gnCommHandleIndex, 1);
    m_cmdTzRead.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CPasstimeDlg::OnTzwrite() 
{
	// TODO: Add your control notification handler code here
	long vnPassTimeID;
	long vnResultCode;
	
	PASSCTRLTIMEINFO vPassCtrlTime;
	long mlngTmpBuff[DATALEN];
	
	m_cmdTzWrite.EnableWindow(FALSE);	
	MULTIPROC();
	
	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdTzWrite.EnableWindow(TRUE);
		goto END;
	}
	UpdateData(TRUE);
	ZeroMemory(&vPassCtrlTime, sizeof(PASSCTRLTIMEINFO));	
	vPassCtrlTime.mPassCtrlTime[0].StartHour=(BYTE)m_vnSh1;	vPassCtrlTime.mPassCtrlTime[0].StartMinute=(BYTE)m_vnSm1;
	vPassCtrlTime.mPassCtrlTime[1].StartHour=(BYTE)m_vnSh2;	vPassCtrlTime.mPassCtrlTime[1].StartMinute=(BYTE)m_vnSm2;
	vPassCtrlTime.mPassCtrlTime[2].StartHour=(BYTE)m_vnSh3;	vPassCtrlTime.mPassCtrlTime[2].StartMinute=(BYTE)m_vnSm3;
	vPassCtrlTime.mPassCtrlTime[3].StartHour=(BYTE)m_vnSh4;	vPassCtrlTime.mPassCtrlTime[3].StartMinute=(BYTE)m_vnSm4;
	vPassCtrlTime.mPassCtrlTime[4].StartHour=(BYTE)m_vnSh5;	vPassCtrlTime.mPassCtrlTime[4].StartMinute=(BYTE)m_vnSm5;
	vPassCtrlTime.mPassCtrlTime[5].StartHour=(BYTE)m_vnSh6;	vPassCtrlTime.mPassCtrlTime[5].StartMinute=(BYTE)m_vnSm6;
	vPassCtrlTime.mPassCtrlTime[6].StartHour=(BYTE)m_vnSh7;	vPassCtrlTime.mPassCtrlTime[6].StartMinute=(BYTE)m_vnSm7;
	
	vPassCtrlTime.mPassCtrlTime[0].EndHour=(BYTE)m_vnEh1;	vPassCtrlTime.mPassCtrlTime[0].EndMinute=(BYTE)m_vnEm1;
	vPassCtrlTime.mPassCtrlTime[1].EndHour=(BYTE)m_vnEh2;	vPassCtrlTime.mPassCtrlTime[1].EndMinute=(BYTE)m_vnEm2;
	vPassCtrlTime.mPassCtrlTime[2].EndHour=(BYTE)m_vnEh3;	vPassCtrlTime.mPassCtrlTime[2].EndMinute=(BYTE)m_vnEm3;
	vPassCtrlTime.mPassCtrlTime[3].EndHour=(BYTE)m_vnEh4;	vPassCtrlTime.mPassCtrlTime[3].EndMinute=(BYTE)m_vnEm4;
	vPassCtrlTime.mPassCtrlTime[4].EndHour=(BYTE)m_vnEh5;	vPassCtrlTime.mPassCtrlTime[4].EndMinute=(BYTE)m_vnEm5;
	vPassCtrlTime.mPassCtrlTime[5].EndHour=(BYTE)m_vnEh6;	vPassCtrlTime.mPassCtrlTime[5].EndMinute=(BYTE)m_vnEm6;
	vPassCtrlTime.mPassCtrlTime[6].EndHour=(BYTE)m_vnEh7;	vPassCtrlTime.mPassCtrlTime[6].EndMinute=(BYTE)m_vnEm7;
	CopyMemory( &mlngTmpBuff[0], &vPassCtrlTime,sizeof(PASSCTRLTIMEINFO));

	m_strMessage= "Writeing...";
	UpdateData(FALSE);
	vnPassTimeID = 1;
	if(m_vnTz>=1)	
		vnPassTimeID=m_vnTz;	
	
	if(vnPassTimeID < 1 || vnPassTimeID > 50)
		vnPassTimeID = 1;	
	vnResultCode = FK_SetPassTime(gnCommHandleIndex, vnPassTimeID, &mlngTmpBuff[0], sizeof(PASSCTRLTIMEINFO));

	if(vnResultCode == RUN_SUCCESS)	
		m_strMessage = "Success!";
	else
		m_strMessage = ReturnResultPrint(vnResultCode);

END:
	FK_EnableDevice (gnCommHandleIndex, 1);
    m_cmdTzWrite.EnableWindow(TRUE);
	UpdateData(FALSE);
}
