// AdjustDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FKAttendDllSample.h"
#include "AdjustDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


extern CString ReturnResultPrint(long anResultCode);
extern long gnCommHandleIndex;

/////////////////////////////////////////////////////////////////////////////
// CAdjustDlg dialog


CAdjustDlg::CAdjustDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAdjustDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAdjustDlg)
	m_strMessage = _T("Message");
	m_vnAdjustMonth = 0;
	m_vnAdjustMinute = 0;
	m_vnAdjustHour = 0;
	m_vnAdjustDay = 0;
	m_vnRestoreDay = 0;
	m_vnRestoreHour = 0;
	m_vnRestoreMinute = 0;
	m_vnRestoreMonth = 0;
	//}}AFX_DATA_INIT
}


void CAdjustDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAdjustDlg)
	DDX_Control(pDX, IDC_RESTORESTATE_COMB, m_combRestoreState);
	DDX_Control(pDX, IDC_ADJUSTSTATE_COMB, m_combAdjustState);
	DDX_Control(pDX, IDB_SET, m_cmdSet);
	DDX_Control(pDX, IDB_GET, m_cmdGet);
	DDX_Text(pDX, IDT_MESSAGE, m_strMessage);
	DDX_Text(pDX, IDE_ADJUST_MONTH, m_vnAdjustMonth);
	DDX_Text(pDX, IDE_ADJUST_MINUTE, m_vnAdjustMinute);
	DDX_Text(pDX, IDE_ADJUST_HOUR, m_vnAdjustHour);
	DDX_Text(pDX, IDE_ADJUST_DAY, m_vnAdjustDay);
	DDX_Text(pDX, IDE_RESTORE_DAY, m_vnRestoreDay);
	DDX_Text(pDX, IDE_RESTORE_HOUR, m_vnRestoreHour);
	DDX_Text(pDX, IDE_RESTORE_MINUTE, m_vnRestoreMinute);
	DDX_Text(pDX, IDE_RESTORE_MONTH, m_vnRestoreMonth);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAdjustDlg, CDialog)
	//{{AFX_MSG_MAP(CAdjustDlg)
	ON_BN_CLICKED(IDB_GET, OnGet)
	ON_BN_CLICKED(IDB_SET, OnSet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAdjustDlg message handlers

BOOL CAdjustDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	::ShowWindow(AfxGetApp()->GetMainWnd()->m_hWnd,SW_SHOW);
	return CDialog::DestroyWindow();
}

BOOL CAdjustDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here	

	m_combAdjustState.AddString("None");
	m_combAdjustState.AddString("-1");
	m_combAdjustState.AddString("+1");
	m_combAdjustState.SetCurSel(0);

	m_combRestoreState.AddString("None");
	m_combRestoreState.AddString("-1");
	m_combRestoreState.AddString("+1");
	m_combRestoreState.SetCurSel(0);


	return true;  // return true unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return false
}

void CAdjustDlg::OnGet() 
{
	// TODO: Add your control notification handler code here
	long vAdjustedState;
	long vAdjustedMonth, vAdjustedDay, vAdjustedHour, vAdjustedMinute;
	long vRestoredState;
	long vRestoredMonth, vRestoredDay, vRestoredHour, vRestoredMinute;
	BOOL vbRet;
		
	m_strMessage = "Working";
	UpdateData(false);

	MULTIPROC();
	
	m_cmdGet.EnableWindow(false);
	vbRet = FK_EnableDevice(gnCommHandleIndex, false);
	if (vbRet==false)
	{
		m_cmdGet.EnableWindow(true);
		m_strMessage = gstrNoDevice;
		goto END;
	}
	vbRet = FK_GetAdjustInfo(gnCommHandleIndex,	&vAdjustedState, &vAdjustedMonth, &vAdjustedDay, &vAdjustedHour, &vAdjustedMinute,
												&vRestoredState, &vRestoredMonth, &vRestoredDay, &vRestoredHour, &vRestoredMinute);
	if (vbRet = true)
	{
		if(vAdjustedState<3)
			m_combAdjustState.SetCurSel(vAdjustedState);
		else
			m_combAdjustState.SetCurSel(0);
		
		m_vnAdjustMonth=vAdjustedMonth;		
		m_vnAdjustDay= vAdjustedDay;
		m_vnAdjustHour = vAdjustedHour;
		m_vnAdjustMinute = vAdjustedMinute;
		
		if(vRestoredState<3)
			m_combRestoreState.SetCurSel(vRestoredState);
		else
			m_combRestoreState.SetCurSel(0);
		
		m_vnRestoreMonth = vRestoredMonth;
		m_vnRestoreDay = vRestoredDay;
		m_vnRestoreHour= vRestoredHour;
		m_vnRestoreMinute= vRestoredMinute;
		m_strMessage = "Success!";
	}
	else
		m_strMessage = "Faile!";
	

END:
	m_cmdGet.EnableWindow(TRUE);
    FK_EnableDevice(gnCommHandleIndex, true);
	UpdateData(false);
}

void CAdjustDlg::OnSet() 
{
	// TODO: Add your control notification handler code here
	long vAdjustedState;
	long vAdjustedMonth, vAdjustedDay, vAdjustedHour, vAdjustedMinute;
	long vRestoredState;
	long vRestoredMonth, vRestoredDay, vRestoredHour, vRestoredMinute;
	BOOL vbRet;
	
	MULTIPROC();
	
	m_cmdSet.EnableWindow(false);
	vbRet = FK_EnableDevice(gnCommHandleIndex, false);
	if(vbRet == FALSE)
	{
		m_cmdSet.EnableWindow(true);
		m_strMessage = gstrNoDevice;
		goto END;
	}
	
	UpdateData(true);
	vAdjustedState = m_combAdjustState.GetCurSel();
	vAdjustedMonth = m_vnAdjustMonth;
	vAdjustedDay = m_vnAdjustDay;
	vAdjustedHour = m_vnAdjustHour;
	vAdjustedMinute = m_vnAdjustMinute;
	
	vRestoredState = m_combRestoreState.GetCurSel();
	vRestoredMonth = m_vnRestoreMonth;
	vRestoredDay = m_vnRestoreDay;
	vRestoredHour = m_vnRestoreHour;
	vRestoredMinute = m_vnRestoreMinute;
	
	m_strMessage = "Working!...";	
	UpdateData(false);
	vbRet = FK_SetAdjustInfo(gnCommHandleIndex, vAdjustedState, vAdjustedMonth, vAdjustedDay, vAdjustedHour,vAdjustedMinute,
												vRestoredState, vRestoredMonth, vRestoredDay, vRestoredHour, vRestoredMinute);
	if(vbRet == TRUE)
		m_strMessage = "Success!";
	else
		m_strMessage = "Faile!";	

END:
	FK_EnableDevice(gnCommHandleIndex, true);
	m_cmdSet.EnableWindow(true);
	UpdateData(false);
}
