// MainDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FKAttendDllSample.h"

#include "MainDlg.h"
#include "EnrollDlg.h"
#include "LogData.h"
#include "SystemInfoDlg.h"
#include "ProductDlg.h"
#include "UserInfoDlg.h"
#include "RealTimeInfoDlg.h"
#include "PasstimeDlg.h"
#include "BellInfoDlg.h"
#include "AdjustDlg.h"
#include "NetInfoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainDlg dialog
extern CString ReturnResultPrint(long anResultCode);
extern BOOL gbOpenFlag;
extern long gnCommHandleIndex;

CMainDlg::CMainDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMainDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMainDlg)
	m_vnMachineNumber = 1;
	m_vnLicense = 0;
	m_vStrIPAddr = _T("192.168.0.9");
	m_vnPortNum = 5005;
	m_vnTelNo = 806;
	m_vnTimeOut = 5000;
	m_vnPassword = 0;
	m_vnWaitTIme = 10;
	m_vnComTimeOut = 3000;
	//}}AFX_DATA_INIT
}


void CMainDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainDlg)
	DDX_Control(pDX, IDC_UDP_CHK, m_chkUDP);
	DDX_Control(pDX, IDC_MODEM_CHK, m_chkModem);
	DDX_Control(pDX, IDC_BAUDRATE, m_cmbBaudrate);
	DDX_Control(pDX, IDC_COMPORT, m_cmbComPort);
	DDX_Text(pDX, IDE_MACHINENUMBER, m_vnMachineNumber);	
	DDX_Text(pDX, IDE_LICENSE, m_vnLicense);
	DDX_Text(pDX, IDE_IPADDR, m_vStrIPAddr);
	DDX_Text(pDX, IDE_PORTNUM, m_vnPortNum);
	DDX_Text(pDX, IDE_TELNO, m_vnTelNo);
	DDX_Text(pDX, IDE_TIMEOUT, m_vnTimeOut);
	DDX_Text(pDX, IDE_PASSWORD, m_vnPassword);
	DDX_Text(pDX, IDE_WAITTIME, m_vnWaitTIme);
	DDX_Text(pDX, IDE_COMTIMEOUT, m_vnComTimeOut);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMainDlg, CDialog)
	//{{AFX_MSG_MAP(CMainDlg)
	ON_BN_CLICKED(IDR_NETWORK, OnNetwork)
	ON_BN_CLICKED(IDR_SERIAL, OnSerial)
	ON_BN_CLICKED(IDR_USB, OnUsb)
	ON_BN_CLICKED(IDB_BELLTIME, OnBelltime)
	ON_BN_CLICKED(IDB_CLOSECOMM, OnClosecomm)
	ON_BN_CLICKED(IDB_ENROLLDATA, OnEnrolldata)
	ON_BN_CLICKED(IDB_GETPRODUCT, OnGetproduct)
	ON_BN_CLICKED(IDB_LOGDATA, OnLogdata)
	ON_BN_CLICKED(IDB_OPENCOMM, OnOpencomm)
	ON_BN_CLICKED(IDB_SETADJUSTINFO, OnSetadjustinfo)
	ON_BN_CLICKED(IDB_SETNETWORK, OnSetnetwork)
	ON_BN_CLICKED(IDB_SETPASSTIME, OnSetpasstime)
	ON_BN_CLICKED(IDB_SETREALTIMEINFO, OnSetrealtimeinfo)
	ON_BN_CLICKED(IDB_SETUSERINFO, OnSetuserinfo)
	ON_BN_CLICKED(IDB_SYSTEMINFO, OnSysteminfo)
	ON_BN_CLICKED(IDC_MODEM_CHK, OnModemChk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainDlg message handlers

void CMainDlg::ControlItems(long abKind)
{
	UpdateData(TRUE);

	GetDlgItem(IDG_FRAME0)->EnableWindow(FALSE);	
	GetDlgItem(IDT_COMPORT)->EnableWindow(FALSE);
	GetDlgItem(IDC_COMPORT)->EnableWindow(FALSE);
	GetDlgItem(IDT_BAUDRATE)->EnableWindow(FALSE);
	GetDlgItem(IDC_BAUDRATE)->EnableWindow(FALSE);
	GetDlgItem(IDC_MODEM_CHK)->EnableWindow(FALSE);
	GetDlgItem(IDT_TELNO)->EnableWindow(FALSE);
	GetDlgItem(IDE_TELNO)->EnableWindow(FALSE);
	GetDlgItem(IDT_WAITTIME)->EnableWindow(FALSE);
	GetDlgItem(IDE_WAITTIME)->EnableWindow(FALSE);
	GetDlgItem(IDT_WAITTIME_)->EnableWindow(FALSE);
	GetDlgItem(IDT_COMTIMEOUT)->EnableWindow(FALSE);
	GetDlgItem(IDE_COMTIMEOUT)->EnableWindow(FALSE);
	GetDlgItem(IDT_COMTIMEOUTT)->EnableWindow(FALSE);

	GetDlgItem(IDG_FRAME1)->EnableWindow(FALSE);	
	GetDlgItem(IDT_IPADDR)->EnableWindow(FALSE);
	GetDlgItem(IDE_IPADDR)->EnableWindow(FALSE);
	GetDlgItem(IDT_PORTNUM)->EnableWindow(FALSE);
	GetDlgItem(IDE_PORTNUM)->EnableWindow(FALSE);
	GetDlgItem(IDT_PASSWORD)->EnableWindow(FALSE);
	GetDlgItem(IDE_PASSWORD)->EnableWindow(FALSE);
	GetDlgItem(IDT_TIMEOUT)->EnableWindow(FALSE);
	GetDlgItem(IDE_TIMEOUT)->EnableWindow(FALSE);
	GetDlgItem(IDT_TIMEOUT_)->EnableWindow(FALSE);
	GetDlgItem(IDC_UDP_CHK)->EnableWindow(FALSE);

	switch(abKind)
	{
		case 2:
			GetDlgItem(IDC_MODEM_CHK)->EnableWindow(TRUE);
			GetDlgItem(IDT_COMPORT)->EnableWindow(TRUE);
			GetDlgItem(IDC_COMPORT)->EnableWindow(TRUE);
			GetDlgItem(IDT_BAUDRATE)->EnableWindow(TRUE);
			GetDlgItem(IDC_BAUDRATE)->EnableWindow(TRUE);
			GetDlgItem(IDT_COMTIMEOUT)->EnableWindow(TRUE);
			GetDlgItem(IDE_COMTIMEOUT)->EnableWindow(TRUE);
			GetDlgItem(IDT_COMTIMEOUTT)->EnableWindow(TRUE);			
		break;

		case 3:			
			GetDlgItem(IDT_IPADDR)->EnableWindow(TRUE);
			GetDlgItem(IDE_IPADDR)->EnableWindow(TRUE);
			GetDlgItem(IDT_PORTNUM)->EnableWindow(TRUE);
			GetDlgItem(IDE_PORTNUM)->EnableWindow(TRUE);
			GetDlgItem(IDT_PASSWORD)->EnableWindow(TRUE);
			GetDlgItem(IDE_PASSWORD)->EnableWindow(TRUE);
			GetDlgItem(IDT_TIMEOUT)->EnableWindow(TRUE);
			GetDlgItem(IDE_TIMEOUT)->EnableWindow(TRUE);
			GetDlgItem(IDT_TIMEOUT_)->EnableWindow(TRUE);
			GetDlgItem(IDC_UDP_CHK)->EnableWindow(TRUE);
		break;
	}

	UpdateData(false);
}

void CMainDlg::LoadInterfaceValue(void)
{

	m_vnComKind=0;
	m_vnMachineNumber=1;
	m_vnLicense=0;

	m_vStrIPAddr="192.168.0.9";
	m_vnPortNum=5005;
	m_vnTelNo=806;
	m_vnTimeOut=5000;
	m_vnPassword=0;
	m_vnWaitTIme=20;

	for(int i=0; i<10; i++)
	{
		CString vStr;
		vStr.Format("%d", i+1);
		m_cmbComPort.AddString(vStr);
	}
	m_cmbComPort.SetCurSel(0);

	m_cmbBaudrate.AddString("9600");	
	m_cmbBaudrate.AddString("19200");
	m_cmbBaudrate.AddString("38400");
	m_cmbBaudrate.AddString("57600");
	m_cmbBaudrate.AddString("115200");
	m_cmbBaudrate.SetCurSel(0);

	OnUsb();

	ButtonView(FALSE);

	UpdateData(false);

}

void CMainDlg::ButtonView(BOOL abflag)
{

	GetDlgItem(IDB_OPENCOMM)->EnableWindow(!abflag);
	GetDlgItem(IDB_CLOSECOMM)->EnableWindow(abflag);
	GetDlgItem(IDB_SYSTEMINFO)->EnableWindow(abflag);

	GetDlgItem(IDB_GETPRODUCT)->EnableWindow(abflag);
	GetDlgItem(IDB_BELLTIME)->EnableWindow(abflag);
	GetDlgItem(IDB_SETUSERINFO)->EnableWindow(abflag);
	GetDlgItem(IDB_SETPASSTIME)->EnableWindow(abflag);
	GetDlgItem(IDB_SETADJUSTINFO)->EnableWindow(abflag);
	GetDlgItem(IDB_SETREALTIMEINFO)->EnableWindow(abflag);
	GetDlgItem(IDB_SETNETWORK)->EnableWindow(abflag);
	UpdateData(FALSE);
}



BOOL CMainDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();	
	// TODO: Add extra initialization here

	LoadInterfaceValue();
	gbOpenFlag=FALSE;
	gnCommHandleIndex=0;

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CMainDlg::OnNetwork() 
{
	// TODO: Add your control notification handler code here
	CButton* pButton;
	pButton = (CButton*)GetDlgItem(IDR_NETWORK);
	pButton->SetCheck(1);
	ControlItems(3);
	m_vnComKind=3;
}

void CMainDlg::OnSerial() 
{
	// TODO: Add your control notification handler code here
	CButton* pButton;
	pButton = (CButton*)GetDlgItem(IDR_SERIAL);	
	pButton->SetCheck(1);
	ControlItems(2);
	m_vnComKind=2;
}

void CMainDlg::OnUsb() 
{
	// TODO: Add your control notification handler code here
	CButton* pButton;
	pButton = (CButton*)GetDlgItem(IDR_USB);
	pButton->SetCheck(1);
	ControlItems(1);
	m_vnComKind=1;
}


void CMainDlg::OnOpencomm() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	CString vStr;
	gnCommHandleIndex=0;
	if(m_vnComKind==1)	
		gnCommHandleIndex = FK_ConnectUSB(m_vnMachineNumber, m_vnLicense);
	
	if(m_vnComKind==2)
	{
		long vnCommPort=0;
		long vnCommBaudrate=0;
		long vnCommselIndex=0;
		long vnCommBaudrateselIndex=0;
		CString vstrTelNumber;

		if(m_chkModem.GetCheck()==1)
		{
			vstrTelNumber.Empty();
			ltoa(m_vnTelNo, (LPSTR)vstrTelNumber.operator LPCTSTR(), sizeof(long));
		}
		vStr.Empty();
		vnCommselIndex = m_cmbComPort.GetCurSel();
		m_cmbComPort.GetLBText(vnCommselIndex, vStr);
		vnCommPort=atol(vStr.operator LPCTSTR());

		vStr.Empty();
		vnCommBaudrateselIndex=m_cmbBaudrate.GetCurSel();
		m_cmbBaudrate.GetLBText(vnCommBaudrateselIndex, vStr);
		vnCommBaudrate=atol(vStr.operator LPCTSTR());
		gnCommHandleIndex = FK_ConnectComm(m_vnMachineNumber, vnCommPort, vnCommBaudrate, (LPSTR)vstrTelNumber.operator LPCTSTR(), m_vnWaitTIme, m_vnLicense,m_vnComTimeOut);
	}
	if(m_vnComKind==3)
	{
		long vnProtocolType=0;
		if(m_chkUDP.GetCheck()== 0)
            vnProtocolType = PROTOCOL_TCPIP;
		else        
            vnProtocolType = PROTOCOL_UDP;
        
		gnCommHandleIndex = FK_ConnectNet(m_vnMachineNumber, (LPSTR)m_vStrIPAddr.operator LPCTSTR(), m_vnPortNum, m_vnTimeOut, vnProtocolType, m_vnPassword, m_vnLicense);
	}

	if(gnCommHandleIndex>=1)
	{
		gbOpenFlag=TRUE;
		ButtonView(TRUE);
	}
	else
	{
		vStr=ReturnResultPrint(gnCommHandleIndex);
		AfxMessageBox(vStr);
	}
}


void CMainDlg::OnClosecomm() 
{
	// TODO: Add your control notification handler code here
	if(gbOpenFlag == TRUE)
	{
        FK_DisConnect( gnCommHandleIndex);
        gbOpenFlag = FALSE;
        ButtonView(FALSE);
    }
}

void CMainDlg::OnEnrolldata() 
{
	// TODO: Add your control notification handler code here
	ShowWindow(SW_HIDE);
	CEnrollDlg dlg;
	dlg.DoModal();
}

void CMainDlg::OnLogdata() 
{
	// TODO: Add your control notification handler code here
	ShowWindow(SW_HIDE);
	CLogData dlg;
	dlg.DoModal();
	
}

void CMainDlg::OnGetproduct() 
{
	// TODO: Add your control notification handler code here
	ShowWindow(SW_HIDE);
	CProductDlg dlg;
	dlg.DoModal();
}

void CMainDlg::OnSetadjustinfo() 
{
	// TODO: Add your control notification handler code here
	ShowWindow(SW_HIDE);
	CAdjustDlg dlg;
	dlg.DoModal();
}

void CMainDlg::OnSetnetwork() 
{
	// TODO: Add your control notification handler code here
	ShowWindow(SW_HIDE);
	CNetInfoDlg dlg;
	dlg.DoModal();
	
}

void CMainDlg::OnSetpasstime() 
{
	// TODO: Add your control notification handler code here
	ShowWindow(SW_HIDE);
	CPasstimeDlg dlg;
	dlg.DoModal();
}


void CMainDlg::OnBelltime() 
{
	// TODO: Add your control notification handler code here
	ShowWindow(SW_HIDE);
	CBellInfoDlg dlg;
	dlg.DoModal();
}

void CMainDlg::OnSysteminfo() 
{
	// TODO: Add your control notification handler code here
	ShowWindow(SW_HIDE);
	CSystemInfoDlg dlg;
	dlg.DoModal();
	
}

void CMainDlg::OnSetrealtimeinfo() 
{
	// TODO: Add your control notification handler code here
	ShowWindow(SW_HIDE);
	CRealTimeInfoDlg dlg;
	dlg.DoModal();
}

void CMainDlg::OnSetuserinfo() 
{
	// TODO: Add your control notification handler code here
	ShowWindow(SW_HIDE);
	CUserInfoDlg dlg;
	dlg.DoModal();
}


void CMainDlg::OnModemChk() 
{
	// TODO: Add your control notification handler code here
	if(m_chkModem.GetCheck()==1)
	{
		GetDlgItem(IDT_TELNO)->EnableWindow(TRUE);
		GetDlgItem(IDE_TELNO)->EnableWindow(TRUE);
		GetDlgItem(IDT_WAITTIME)->EnableWindow(TRUE);
		GetDlgItem(IDE_WAITTIME)->EnableWindow(TRUE);
		GetDlgItem(IDT_WAITTIME_)->EnableWindow(TRUE);
	}
	else
	{		
		GetDlgItem(IDT_TELNO)->EnableWindow(FALSE);
		GetDlgItem(IDE_TELNO)->EnableWindow(FALSE);
		GetDlgItem(IDT_WAITTIME)->EnableWindow(FALSE);
		GetDlgItem(IDE_WAITTIME)->EnableWindow(FALSE);
		GetDlgItem(IDT_WAITTIME_)->EnableWindow(FALSE);
	}
	UpdateData(false);
}
