// LogData.cpp : implementation file
//

#include "stdafx.h"
#include "FKAttendDllSample.h"
#include "LogData.h"

#include "PreDefine.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLogData dialog
extern CString ReturnResultPrint(long anResultCode);
extern long gnCommHandleIndex;
extern BOOL gbOpenFlag;

#define DEF_MAX_LOGCOUNT	200000    // max log data count to support by device.
#define DEF_MAX_DISPCOUNT	30000     // max count to show on a grid.
#define DEF_MUL_TWIPS		15



static char *GLogViewFilter[5] = {"","EnrollNo","VerifyMode","InOutMode","DateTime"};
static char *SLogViewFilter[6] = {"","SEnrollNo","GEnrollNo","Manipulation","BackupNo","DateTime"};


CLogData::CLogData(CWnd* pParent /*=NULL*/)
	: CDialog(CLogData::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLogData)
	m_strMessage = _T("Message");
	m_strToTalNumber = _T("Total : 0");
	m_strLogNumber = _T("Log Data : 0");
	//}}AFX_DATA_INIT
}

void CLogData::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLogData)
	DDX_Control(pDX, IDC_SAVEFILE_CHK, m_chkSave);
	DDX_Control(pDX, IDC_READMARK_CHK, m_chkReadMark);
	DDX_Control(pDX, IDB_READGLOD_USB, m_cmdUsbGLogData);
	DDX_Control(pDX, IDB_EMPTYGLOG, m_cmdEmptyGLogData);
	DDX_Control(pDX, IDB_READGLOG, m_cmdGLogData);
	DDX_Control(pDX, IDB_READSLOG_USB, m_cmdUsbSLogData);
	DDX_Control(pDX, IDB_EMPTYSLOG, m_cmdEmptySLogData);
	DDX_Control(pDX, IDB_READSLOG, m_cmdSLogData);
	DDX_Text(pDX, IDT_MESSAGE, m_strMessage);
	DDX_Text(pDX, IDT_TOTALNUMBER, m_strToTalNumber);
	DDX_Control(pDX, IDC_LOGVIEW_GRID, m_gridLogView);
	DDX_Text(pDX, IDT_LOGDATANUMBER, m_strLogNumber);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLogData, CDialog)
	//{{AFX_MSG_MAP(CLogData)
	ON_BN_CLICKED(IDB_EMPTYGLOG, OnEmptyglog)
	ON_BN_CLICKED(IDB_EMPTYSLOG, OnEmptyslog)
	ON_BN_CLICKED(IDB_READSLOG, OnReadslog)
	ON_BN_CLICKED(IDB_READSLOG_USB, OnReadslogUsb)
	ON_BN_CLICKED(IDB_READGLOG, OnReadglog)
	ON_BN_CLICKED(IDB_READGLOD_USB, OnReadglodUsb)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLogData message handlers

BOOL CLogData::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	m_gridLogView.Clear();
	::ShowWindow(AfxGetApp()->GetMainWnd()->m_hWnd,SW_SHOW);
	return CDialog::DestroyWindow();
}

void CLogData::OwnerEnableButtons(BOOL abEnableFlag)
{
    BOOL vbFrmOpenFlag;
    vbFrmOpenFlag = gbOpenFlag;
    m_cmdSLogData.EnableWindow(vbFrmOpenFlag & abEnableFlag);
    m_cmdEmptySLogData.EnableWindow(vbFrmOpenFlag & abEnableFlag);
    m_cmdUsbSLogData.EnableWindow(abEnableFlag);
    m_cmdGLogData.EnableWindow(vbFrmOpenFlag & abEnableFlag);
    m_cmdEmptyGLogData.EnableWindow(vbFrmOpenFlag & abEnableFlag);
    m_cmdUsbGLogData.EnableWindow(abEnableFlag);
	UpdateData(false);
}

CString CLogData::funcMakeGeneralLogFileData(long anCount, long aSEnrollNumber, long aVerifyMode, long aInOutMode, DATE adwDate)
{
    CString vstrData;
    CString vstrDTime;
    CString vStr;
	COleDateTime vOleDateTime(adwDate);

	vstrData.Format("%d \t %d \t %d \t %d \t", anCount, aSEnrollNumber, aVerifyMode, aInOutMode);
	
	vstrDTime.Format("%04d/%02d/%02d %02d:%02d:%02d", vOleDateTime.GetYear(),vOleDateTime.GetMonth(),vOleDateTime.GetDay(), 
			                                            vOleDateTime.GetHour(),vOleDateTime.GetMinute(),vOleDateTime.GetSecond());
    vStr.Empty();
    vStr.Format("%s %s\n",vstrData , vstrDTime);
	return vStr;
}

void CLogData::funcGetSuperLogData(BOOL abUSBFlag)
{
    long vSEnrollNumber;
    long vGEnrollNumber;
    long vManipulation;
    long vBackupNumber;
    DATE vdwDate;
    long vnii;    
    long vnReadMark;
    long vnResultCode;
	CString vstrFileName, vStr;
	VARIANT vnIndex;	

    m_strMessage = "Waiting...";
    m_strToTalNumber = "Total : 0";
    MULTIPROC();

	m_gridLogView.SetCols(6);
	m_gridLogView.SetRows(1);
	m_gridLogView.SetColWidth(0,1000);
	m_gridLogView.SetColWidth(1,1500);
	m_gridLogView.SetColWidth(2,1500);
	m_gridLogView.SetColWidth(3,1800);
	m_gridLogView.SetColWidth(4,1500);
	m_gridLogView.SetColWidth(5,2000);

	for(int i = 0 ; i < 6; i++)
	{
		m_gridLogView.SetCellAlignment(2);		
		m_gridLogView.SetTextMatrix(0, i, SLogViewFilter[i]);
	}

    if(abUSBFlag == TRUE)
	{
		CString strFilter;
		strFilter = "SLog Files (*.txt)|*.txt|All Files (*.*)|*.*";
		CFileDialog dlgOpen(TRUE, NULL, NULL, OFN_HIDEREADONLY, strFilter);
        if(dlgOpen.DoModal()==IDOK)
		{
			vstrFileName = dlgOpen.GetFileName();
			if(vstrFileName.IsEmpty())
				goto END;
		}
		else goto END;
	}
    else
	{
        vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
        if(vnResultCode != RUN_SUCCESS)
		{
            m_strMessage = gstrNoDevice;
            goto END;
		}
    }

    MULTIPROC();
    if(abUSBFlag == TRUE)
        vnResultCode = FK_USBLoadSuperLogDataFromFile(gnCommHandleIndex, (LPSTR)vstrFileName.operator LPCTSTR());
    else
	{
        if(m_chkReadMark.GetCheck() == 1)
            vnReadMark = 1;
        else
            vnReadMark = 0;
        
        vnResultCode = FK_LoadSuperLogData(gnCommHandleIndex, vnReadMark);
    }

    if(vnResultCode != RUN_SUCCESS)
        m_strMessage = ReturnResultPrint(vnResultCode);
    else
	{
        m_strMessage = "Getting...";
        vnii = 1;		
		
		while(vnResultCode != RUNERR_DATAARRAY_END)
		{
			MULTIPROC();

            vnResultCode = FK_GetSuperLogData(gnCommHandleIndex,
				                              &vSEnrollNumber,
											  &vGEnrollNumber,
											  &vManipulation,
											  &vBackupNumber,
											  &vdwDate);

            if(vnResultCode != RUN_SUCCESS)
			{
                if(vnResultCode = RUNERR_DATAARRAY_END)
                    vnResultCode = RUN_SUCCESS;                    
                break;
			}
			

			vStr.Format("%d",vnii);
			vnIndex.vt=VT_I2;
			vnIndex.iVal=(short)vnii;
			m_gridLogView.AddItem(vStr,vnIndex);

			vStr.Format("%d", vnii);
			m_gridLogView.SetRow(vnii);
			m_gridLogView.SetCol(0);
			m_gridLogView.SetText((LPSTR)vStr.operator LPCTSTR());

			vStr.Format("%d", vSEnrollNumber);
			vStr.TrimLeft();
			vStr.TrimRight();
			m_gridLogView.SetCol(1);
			m_gridLogView.SetText((LPSTR)vStr.operator LPCTSTR());

			vStr.Format("%d", vGEnrollNumber);
			vStr.TrimLeft();
			vStr.TrimRight();

			m_gridLogView.SetCol(2);
			m_gridLogView.SetText((LPSTR)vStr.operator LPCTSTR());

            m_gridLogView.SetCol(3);
            switch(vManipulation)
			{
				case LOG_ENROLL_USER:
                    vStr= "Enroll User";
					break;

                case LOG_ENROLL_MANAGER:
                    vStr = "Enroll Manager";
					break;

                case LOG_ENROLL_DELFP:
                    vStr = "Delete Fp Data";
					break;

                case LOG_ENROLL_DELPASS:
                    vStr = "Delete Password";
					break;

				case LOG_ENROLL_DELCARD:
					vStr = "Delete Card Data";
					break;

				case LOG_LOG_ALLDEL:
                    vStr = "Delete All LogData";
					break;

                case LOG_SETUP_SYS:
                    vStr = "Modify System Info";
					break;

                case LOG_SETUP_TIME:
                    vStr = "Modify System Time";
					break;

                case LOG_SETUP_LOG:
                    vStr = "Modify Log Setting";
					break;

                case LOG_SETUP_COMM:
                    vStr = "Modify Comm Setting";
					break;

                case LOG_PASSTIME:
                    vStr = "Pass Time Set";
					break;

                case LOG_SETUP_DOOR:
                    vStr = "Door Set Log";
					break;

                default:
                    vStr = "--";
					break;
            }

			m_gridLogView.SetText((LPSTR)vStr.operator LPCTSTR());

            m_gridLogView.SetCol(4);
			if(vBackupNumber == BACKUP_PSW)
                vStr = "Password";
            else if(vBackupNumber == BACKUP_CARD)
                vStr = "Card";
            else if(vBackupNumber < BACKUP_PSW)
                vStr.Format("Fp-%d", vBackupNumber);
            else
                vStr = "--";
			m_gridLogView.SetText((LPSTR)vStr.operator LPCTSTR());

            m_gridLogView.SetCol(5);
			
			COleDateTime vOleDateTime(vdwDate);
            vStr.Format("%04d/%02d/%02d %02d:%02d:%02d", vOleDateTime.GetYear(),vOleDateTime.GetMonth(),vOleDateTime.GetDay(),
			                                             vOleDateTime.GetHour(),vOleDateTime.GetMinute(),vOleDateTime.GetSecond());
			m_gridLogView.SetText((LPSTR)vStr.operator LPCTSTR());

			m_strLogNumber.Format("Log Data : %d", vnii);
			m_strToTalNumber.Format("Total : %d", vnii);

			vnii = vnii + 1;            
            MULTIPROC();
			m_gridLogView.Refresh();
			UpdateData(false);
        }
        if(vnResultCode == RUN_SUCCESS)
		{
            if(abUSBFlag == TRUE)
                m_strMessage = "USBReadSuperLogDataFromFile OK";
            else
                m_strMessage = "ReadAllSuperLogData OK";
		}            
        else
            m_strMessage = ReturnResultPrint(vnResultCode);

    }

END:
	if(abUSBFlag == FALSE)
        FK_EnableDevice(gnCommHandleIndex, 1);
	UpdateData(false);    
}

void CLogData::funcGeneralLogDataGridFormat()
{
    m_gridLogView.SetCols(5);
	m_gridLogView.SetRows(1);
	m_gridLogView.SetColWidth(0,1000);
	m_gridLogView.SetColWidth(1,1500);
	m_gridLogView.SetColWidth(2,2500);
	m_gridLogView.SetColWidth(3,1500);
	m_gridLogView.SetColWidth(4,2800);

	for(int i = 0 ; i < 5; i++)
	{
		m_gridLogView.SetCellAlignment(1);		
		m_gridLogView.SetTextMatrix(0, i, GLogViewFilter[i]);
	} 
}

void CLogData::funcShowGeneralLogDataToGrid(long anCount, long aSEnrollNumber,long aVerifyMode, long aInOutMode, DATE adwDate, BOOL abDrawFlag)
{
    CString vStr;

    vStr.Format("%d", anCount);
	m_gridLogView.SetRow(anCount);
	m_gridLogView.SetCol(0);
	m_gridLogView.SetText((LPSTR)vStr.operator LPCTSTR());

	vStr.Format("%d", aSEnrollNumber);
	vStr.TrimLeft();
	vStr.TrimRight();
	m_gridLogView.SetCol(1);
	m_gridLogView.SetText((LPSTR)vStr.operator LPCTSTR());

	m_gridLogView.SetCol(2);

	
    switch(aVerifyMode% LOG_OPEN_DOOR1)
	{
		case LOG_FPVERIFY1:           //1
            vStr = "Fp";
			break;
        case LOG_PASSVERIFY1:         //2
            vStr = "Password";
			break;
        case LOG_CARDVERIFY1:         //3
            vStr = "Card";
			break;
        case LOG_FPPASS_VERIFY1:      //4
            vStr = "Fp+Password";
			break;
        case LOG_FPCARD_VERIFY1:      //5
            vStr = "Fp+Card";
			break;
        case LOG_PASSFP_VERIFY1:      //6
            vStr = "Password+Fp";
			break;
        case LOG_CARDFP_VERIFY1:      //7
            vStr = "Card+Fp";
			break;
        case LOG_JOB_NO_VERIFY1:      //8
            vStr = "Job No";
			break;
        case LOG_CARDPASS_VERIFY1:    //9
            vStr = "Card+Pass";
			break;
        case LOG_CLOSE_DOOR1:         //10
            vStr = "Close Door";
			break;
        case LOG_OPEN_HAND1:          //11
            vStr = "Hand Open";
			break;
        case LOG_PROG_OPEN1:          //12
            vStr = "Prog Open";
			break;
        case LOG_PROG_CLOSE1:         //13
            vStr = "PC Close";
			break;
        case LOG_OPEN_IREGAL1:        //14
            vStr = "Iregal Open";
			break;
        case LOG_CLOSE_IREGAL1:       //15
            vStr = "Iregal Close";
			break;
        case LOG_OPEN_COVER1:         //16
            vStr = "Cover Open";
			break;
        case LOG_CLOSE_COVER1:        //17
            vStr = "Cover Close";
			break;
		default:
            vStr = "--";
			break;
    }	
    if( aVerifyMode / LOG_OPEN_THREAT1== 1)
        vStr = vStr + " & Open Door as Threat";
    else if(aVerifyMode / LOG_OPEN_DOOR1 == 1)
        vStr = vStr + " & Open Door";
    else
        vStr = vStr;
	m_gridLogView.SetText((LPSTR)vStr.operator LPCTSTR());

    m_gridLogView.SetCol(3);
    switch(aInOutMode)
	{
        case LOG_IOMODE_IN1:
            vStr = "IN";
			break;

        case LOG_IOMODE_OUT1:
            vStr = "OUT";
			break;

        case LOG_IOMODE_OVER_IN1:
            vStr = "Over IN";
			break;

        case LOG_IOMODE_OVER_OUT1:
            vStr = "Over OUT";
			break;

        default:
            vStr = "--";
			break;
    }
	m_gridLogView.SetText((LPSTR)vStr.operator LPCTSTR());

    m_gridLogView.SetCol(4);
	COleDateTime vOleDateTime(adwDate);
    vStr.Format("%04d/%02d/%02d %02d:%02d:%02d", vOleDateTime.GetYear(),vOleDateTime.GetMonth(),vOleDateTime.GetDay(),
			                                     vOleDateTime.GetHour(),vOleDateTime.GetMinute(),vOleDateTime.GetSecond());
	m_gridLogView.SetText((LPSTR)vStr.operator LPCTSTR());

	m_strLogNumber.Format("Log Data : %d", anCount);
	m_strToTalNumber.Format("Total : %d", anCount);
    MULTIPROC();

	UpdateData(false);
}
void CLogData::funcGetGeneralLogData(BOOL abUSBFlag)
{
    long vSEnrollNumber, vVerifyMode, vInOutMode;
    CString vstrFileName, vstrTmp, vstrFileData;
    DATE vdwDate;
	long vnCount, vnReadMark;
    CStdioFile  vnFileNum;    
    long vnResultCode;
	VARIANT vnIndex;
	CString vStr;

    m_strMessage= "Waiting...";
    m_strToTalNumber = "Total : 0";

    MULTIPROC();
    funcGeneralLogDataGridFormat();

	if(abUSBFlag == TRUE)
	{
		CString strFilter;
		strFilter = "GLog Files (*.txt)|*.txt|All Files (*.*)|*.*";
		CFileDialog dlgOpen(TRUE, NULL, NULL, OFN_HIDEREADONLY, strFilter);
        if(dlgOpen.DoModal()==IDOK)
		{
			vstrFileName = dlgOpen.GetPathName();
			if(vstrFileName.IsEmpty())
				goto END;
		}
		else goto END;
	}    
    else
	{
        vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
        if(vnResultCode != RUN_SUCCESS)
		{
            m_strMessage= gstrNoDevice;
            goto END;
		}
    }

    MULTIPROC();

    if(abUSBFlag == TRUE)
        vnResultCode = FK_USBLoadGeneralLogDataFromFile(gnCommHandleIndex, (LPSTR)vstrFileName.operator LPCTSTR());
    else
	{
        if(m_chkReadMark.GetCheck()==1)
            vnReadMark = 1;
        else
            vnReadMark = 0;        

        //open file for save		
        if( m_chkSave.GetCheck() == 1)
		{
			CString vStrAppPath;
			::GetCurrentDirectory(255, (LPSTR)vStrAppPath.operator LPCTSTR());
			
            if(vnReadMark == 0)			
                vstrFileName.Format("%s\\AllLog.txt",vStrAppPath);
            else
                vstrFileName.Format("%s\\Log.txt",vStrAppPath);

			vnFileNum.Open(vstrFileName.operator LPCTSTR(), CFile::modeCreate | CFile::modeReadWrite);
			vstrFileData.Format("%d");
            vstrFileData.Format("No. \t EnrNo  \t Verify \t InOut \t DateTime \n");
			vnFileNum.WriteString(vstrFileData);
            
        }
		
        vnResultCode = FK_LoadGeneralLogData(gnCommHandleIndex, vnReadMark);
    }
    if(vnResultCode != RUN_SUCCESS)
       m_strMessage= ReturnResultPrint(vnResultCode);
	else
	{
        m_strMessage= "Getting...";
        MULTIPROC();

        vnCount = 1;		
        while(vnResultCode != RUNERR_DATAARRAY_END)
		{
            vnResultCode = FK_GetGeneralLogData(gnCommHandleIndex,
                                             &vSEnrollNumber,
                                             &vVerifyMode,
                                             &vInOutMode,
                                             &vdwDate);
            if(vnResultCode != RUN_SUCCESS)
			{
                if(vnResultCode == RUNERR_DATAARRAY_END)
                    vnResultCode = RUN_SUCCESS;                
                break;
            }
            if(abUSBFlag == false && m_chkSave.GetCheck() == 1)
			{
                vstrFileData = funcMakeGeneralLogFileData(vnCount, vSEnrollNumber,vVerifyMode, vInOutMode, vdwDate);
                vnFileNum.WriteString(vstrFileData);
            }

			vStr.Format("%d",vnCount);
			vnIndex.vt=VT_I2;
			vnIndex.iVal=(short)vnCount;
			m_gridLogView.AddItem(vStr,vnIndex);
            funcShowGeneralLogDataToGrid(vnCount, vSEnrollNumber, vVerifyMode, vInOutMode,vdwDate, false);
            
            vnCount = vnCount + 1;
        }
        
        if(abUSBFlag == FALSE && m_chkSave.GetCheck()==1)
			vnFileNum.Close();
        

        if(vnResultCode == RUN_SUCCESS)
		{
            if(abUSBFlag == TRUE)
                m_strMessage= "USBReadGeneralLogDataFromFile OK";
            else
                m_strMessage= "ReadGeneralLogData OK";
		}
        else
            m_strMessage= ReturnResultPrint(vnResultCode);
        
	}
    
END:
    if(abUSBFlag == FALSE)
        FK_EnableDevice(gnCommHandleIndex, 1);
	UpdateData(false);
    
}

BOOL CLogData::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_chkReadMark.SetCheck(1);
	OwnerEnableButtons(true);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CLogData::OnEmptyglog() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;

    m_cmdEmptyGLogData.EnableWindow(false);
    m_strMessage = "Working...";
    MULTIPROC();

    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdEmptyGLogData.EnableWindow(true);
        goto END;
    }

    vnResultCode = FK_EmptyGeneralLogData(gnCommHandleIndex);
    m_strMessage = ReturnResultPrint(vnResultCode);

END:
    FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdEmptyGLogData.EnableWindow(true);
	UpdateData(false);
}

void CLogData::OnEmptyslog() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;

    m_cmdEmptySLogData.EnableWindow(false);
    m_strMessage = "Working...";
    MULTIPROC();

    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdEmptySLogData.EnableWindow(true);
        goto END;
    }

    vnResultCode = FK_EmptySuperLogData(gnCommHandleIndex);
    m_strMessage = ReturnResultPrint(gnCommHandleIndex);

END:
    FK_EnableDevice( gnCommHandleIndex, 1);
    m_cmdEmptySLogData.EnableWindow(true);
	UpdateData(false);
}


void CLogData::OnReadslog() 
{
	// TODO: Add your control notification handler code here
	OwnerEnableButtons(false);
    funcGetSuperLogData();
    OwnerEnableButtons(true);
}

void CLogData::OnReadslogUsb() 
{
	// TODO: Add your control notification handler code here
    OwnerEnableButtons(false);
    funcGetSuperLogData(TRUE);
    OwnerEnableButtons(true);
}

void CLogData::OnReadglog() 
{
	// TODO: Add your control notification handler code here

	OwnerEnableButtons(false);
    funcGetGeneralLogData(FALSE);
    OwnerEnableButtons(true);
}

void CLogData::OnReadglodUsb() 
{
	// TODO: Add your control notification handler code here
	OwnerEnableButtons(false);
	funcGetGeneralLogData(TRUE);
	OwnerEnableButtons(true);
	
}
