// NetInfoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FKAttendDllSample.h"
#include "NetInfoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNetInfoDlg dialog
extern CString ReturnResultPrint(long anResultCode);
extern long gnCommHandleIndex;

CNetInfoDlg::CNetInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetInfoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNetInfoDlg)
	m_strServerIp = _T("0.0.0.0");
	m_vnServerPortNum = 0;
	m_strMessage = _T("");
	//}}AFX_DATA_INIT
}


void CNetInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetInfoDlg)
	DDX_Control(pDX, IDB_GET, m_cmdGet);
	DDX_Control(pDX, IDB_SET, m_cmdSet);
	DDX_Control(pDX, IDC_SERVERREQUEST_CHK, m_chkServerRequest);
	DDX_Text(pDX, IDE_SERVER_IPADDR, m_strServerIp);
	DDX_Text(pDX, IDE_SERVER_PORTNUM, m_vnServerPortNum);
	DDX_Text(pDX, IDT_MESSAGE, m_strMessage);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNetInfoDlg, CDialog)
	//{{AFX_MSG_MAP(CNetInfoDlg)
	ON_BN_CLICKED(IDB_GET, OnGet)
	ON_BN_CLICKED(IDB_SET, OnSet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetInfoDlg message handlers

BOOL CNetInfoDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	::ShowWindow(AfxGetApp()->GetMainWnd()->m_hWnd,SW_SHOW);
	return CDialog::DestroyWindow();
}

void CNetInfoDlg::OnGet() 
{
	// TODO: Add your control notification handler code here	
    long vnResultCode;
	BSTR vstrServerIP;
	long vnServerPort;
	long vnServerRequest;	
	WCHAR* vTemp;	
	
	
	vTemp=new WCHAR[256];
	memset(vTemp, 0, sizeof(WCHAR)*256);
	vstrServerIP = (BSTR)vTemp;
	
	m_cmdGet.EnableWindow(FALSE);
	m_strMessage = "Working...";
	m_strServerIp = _T("0.0.0.0");
	m_vnServerPortNum = 0;

	UpdateData(FALSE);
	MULTIPROC();
	
	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	if (vnResultCode != RUN_SUCCESS)	
	{
		m_strMessage = gstrNoDevice;
		m_cmdGet.EnableWindow(TRUE);
		goto END;
	}


	vnResultCode = FK_GetServerNetInfo(gnCommHandleIndex, &vstrServerIP, &vnServerPort, &vnServerRequest);
	
	if (vnResultCode == RUN_SUCCESS)
	{
		m_strServerIp.Format("%s", vstrServerIP);
		m_vnServerPortNum = vnServerPort;
		m_chkServerRequest.SetCheck(vnServerRequest);
	}

END:
	m_strMessage = ReturnResultPrint(vnResultCode);
	FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdGet.EnableWindow(TRUE);
	delete[] vTemp;
	UpdateData(FALSE);
}

void CNetInfoDlg::OnSet() 
{
	// TODO: Add your control notification handler code here
    long vnResultCode;
	CString vstrServerIP;
	long vnServerPort;
	long vnServerRequest;
	
	m_cmdSet.EnableWindow(FALSE);
	MULTIPROC();	
	vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
	
	if (vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdGet.EnableWindow(TRUE);
		goto END;
	}

	UpdateData(TRUE);
	m_strServerIp.TrimLeft();
	m_strServerIp.TrimRight();
	vstrServerIP = m_strServerIp;
	vnServerPort = m_vnServerPortNum;
	vnServerRequest=m_chkServerRequest.GetCheck();	
	m_strMessage = "Working...";
	UpdateData(FALSE);
	vnResultCode = FK_SetServerNetInfo(gnCommHandleIndex, (LPSTR)(LPCTSTR)vstrServerIP, vnServerPort, vnServerRequest);
	m_strMessage = ReturnResultPrint(vnResultCode);

END:
	FK_EnableDevice(gnCommHandleIndex, 0);
    m_cmdSet.EnableWindow(TRUE);
	UpdateData(FALSE);
}
