// UserInfoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FKAttendDllSample.h"
#include "UserInfoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


extern CString ReturnResultPrint(long anResultCode);
extern long gnCommHandleIndex;

LPCTSTR CHINA_FONTNAME = "Arial";
LPCTSTR JAPAN_FONTNAME = "MS PGothic";
LPCTSTR THAI_FONTNAME =  "AngsanaUPC";
/////////////////////////////////////////////////////////////////////////////
// CUserInfoDlg dialog


CUserInfoDlg::CUserInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUserInfoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUserInfoDlg)
	m_strMessage = _T("");
	m_strUserName = _T("");
	m_vnEnrollNumber = 1;
	m_strMessageTool = _T("Thank you");
	m_vnNewsID = 1;
	//}}AFX_DATA_INIT
}


void CUserInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUserInfoDlg)
	DDX_Control(pDX, IDB_DELETECOMPANYNAME, m_cmdDeleteCompanyName);
	DDX_Control(pDX, IDB_SETCOMPANYNAME, m_cmdSetCompanyName);
	DDX_Control(pDX, IDB_DELETENEWSID, m_cmdDeleteNewsID);
	DDX_Control(pDX, IDB_CLEARNEWSID, m_cmdClearNewsID);
	DDX_Control(pDX, IDB_CLEARNEWS, m_cmdClearNews);
	DDX_Control(pDX, IDB_SETALLNEWS, m_cmdSetAllNews);
	DDX_Control(pDX, IDB_GETNEWSID, m_cmdGetNewsID);
	DDX_Control(pDX, IDB_SETNEWSID, m_cmdSetNewsID);
	DDX_Control(pDX, IDB_GETNEWS, m_cmdGetNewsMessage);
	DDX_Control(pDX, IDB_SETNEWS, m_cmdSetNewsMessage);
	DDX_Control(pDX, IDB_GETUSERNAME, m_cmdGetUserName);
	DDX_Control(pDX, IDB_SETUSERNAME, m_cmdSetUserName);
	DDX_Text(pDX, IDT_MESSAGE, m_strMessage);
	DDX_Text(pDX, IDE_USERNAME, m_strUserName);
	DDX_Text(pDX, IDE_ENROLLNUMBER, m_vnEnrollNumber);
	DDX_Text(pDX, IDE_MESSAGE, m_strMessageTool);
	DDX_Text(pDX, IDE_NEWSID, m_vnNewsID);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CUserInfoDlg, CDialog)
	//{{AFX_MSG_MAP(CUserInfoDlg)
	ON_BN_CLICKED(IDB_SETUSERNAME, OnSetusername)
	ON_BN_CLICKED(IDB_GETUSERNAME, OnGetusername)
	ON_BN_CLICKED(IDB_SETNEWS, OnSetnews)
	ON_BN_CLICKED(IDB_GETNEWS, OnGetnews)
	ON_BN_CLICKED(IDB_SETNEWSID, OnSetnewsid)
	ON_BN_CLICKED(IDB_GETNEWSID, OnGetnewsid)
	ON_BN_CLICKED(IDB_SETALLNEWS, OnSetallnews)
	ON_BN_CLICKED(IDB_CLEARNEWS, OnClearnews)
	ON_BN_CLICKED(IDB_CLEARNEWSID, OnClearnewsid)
	ON_BN_CLICKED(IDB_DELETENEWSID, OnDeletenewsid)
	ON_BN_CLICKED(IDB_SETCOMPANYNAME, OnSetcompanyname)
	ON_BN_CLICKED(IDB_DELETECOMPANYNAME, OnDeletecompanyname)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUserInfoDlg message handlers

BOOL CUserInfoDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	::ShowWindow(AfxGetApp()->GetMainWnd()->m_hWnd,SW_SHOW);
	return CDialog::DestroyWindow();
}

void CUserInfoDlg::OnSetusername() 
{
	// TODO: Add your control notification handler code here	
    long vnResultCode;

	UpdateData(true);
	m_strUserName.TrimLeft();
	m_strUserName.TrimRight();
    m_cmdSetUserName.EnableWindow(false);
    m_strMessage = "Working...";
    MULTIPROC();

    UpdateData(false);
    
    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdSetUserName.EnableWindow(true);
        goto END;
    }

    vnResultCode = FK_SetUserName(gnCommHandleIndex,m_vnEnrollNumber, (LPSTR)m_strUserName.operator LPCTSTR());
    if(vnResultCode == RUN_SUCCESS)
        m_strMessage = "SetUserName OK";
    else
        m_strMessage = ReturnResultPrint(vnResultCode);
END:
    FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdSetUserName.EnableWindow(true);
	UpdateData(false);
	
}

void CUserInfoDlg::OnGetusername() 
{
	// TODO: Add your control notification handler code here
	WCHAR* vName;	
	BSTR vpStrName;
    long vnResultCode;

	vName=new WCHAR[20];
	memset(vName, 0, sizeof(WCHAR)*20);
	vpStrName = (BSTR)vName;

	UpdateData(true);  
    m_cmdGetUserName.EnableWindow(false);	
    m_strMessage = "Working...";
    MULTIPROC();

    UpdateData(false);
	
    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdGetUserName.EnableWindow(true);
        goto END;
	}

    vnResultCode = FK_GetUserName(gnCommHandleIndex,m_vnEnrollNumber, &vpStrName);
    if(vnResultCode == RUN_SUCCESS)
	{
        m_strUserName.Format("%s", vpStrName);
        m_strMessage = "GetUserName OK";
	}
    else
        m_strMessage = ReturnResultPrint(vnResultCode);
    
END:
    FK_EnableDevice (gnCommHandleIndex, 1);
    m_cmdGetUserName.EnableWindow(true);
	UpdateData(false);
	delete[] vName;
}

void CUserInfoDlg::OnSetnews() 
{
	// TODO: Add your control notification handler code here

	long vMessageNumber;
    long vnResultCode;
 
    UpdateData(true);
	m_cmdSetNewsMessage.EnableWindow(false); 
    m_strMessage = "Working...";
    MULTIPROC();

    UpdateData(false);

    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdSetNewsMessage.EnableWindow(true);
        goto END;
    }

    vMessageNumber = m_vnNewsID;
	m_strMessageTool.TrimLeft();
	m_strMessageTool.TrimRight();
    vnResultCode = FK_SetNewsMessage(gnCommHandleIndex,vMessageNumber,(LPSTR)m_strMessageTool.operator LPCTSTR());
    if(vnResultCode == RUN_SUCCESS)
        m_strMessage = "Set New Message OK";
    else
        m_strMessage = ReturnResultPrint(vnResultCode);

END:
    FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdSetNewsMessage.EnableWindow(true);
	UpdateData(false);
	
}

void CUserInfoDlg::OnGetnews() 
{
	// TODO: Add your control notification handler code here
	long vMessageNumber;
	long vnResultCode;
    BSTR vNews;
	WCHAR* vstrTemp;

	vstrTemp = new WCHAR[256];
	memset(vstrTemp, 0, sizeof(WCHAR)*256);
	vNews = (BSTR)vstrTemp;

    UpdateData(true);
    m_cmdGetNewsMessage.EnableWindow(false);
	m_strMessage = "Working...";
	m_strMessageTool= "";
    MULTIPROC();

	UpdateData(false);
    
    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdGetNewsMessage.EnableWindow(true);
        goto END;
	}
    
    vMessageNumber = m_vnNewsID;
    
    vnResultCode = FK_GetNewsMessage(gnCommHandleIndex,vMessageNumber,&vNews);
    if(vnResultCode = RUN_SUCCESS)
	{
        m_strMessageTool.Format("%s", vNews);
        m_strMessage = "Get News Message OK";
	}
    else
        m_strMessage = ReturnResultPrint(vnResultCode);
    

END:
    FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdGetNewsMessage.EnableWindow(true);
	UpdateData(false);
	delete[] vstrTemp;
}

void CUserInfoDlg::OnSetnewsid() 
{
	// TODO: Add your control notification handler code here
    long vnResultCode;

  	UpdateData(true);
    m_cmdGetNewsMessage.EnableWindow(false);
    m_strMessage = "Working...";
    MULTIPROC();
    
	UpdateData(false);

    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdSetNewsID.EnableWindow(true);
        goto END;
	}

    vnResultCode = FK_SetUserNewsID(gnCommHandleIndex,m_vnEnrollNumber,m_vnNewsID);
    if(vnResultCode == RUN_SUCCESS)
        m_strMessage = "Set User News  OK";
    else
        m_strMessage = ReturnResultPrint(vnResultCode);

END:
    FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdSetNewsID.EnableWindow(true);
	UpdateData(false);
}

void CUserInfoDlg::OnGetnewsid() 
{
	// TODO: Add your control notification handler code here	
    long vnResultCode;
    
    UpdateData(true);
	m_cmdGetNewsID.EnableWindow(false);    
    m_strMessage = "Working...";
    MULTIPROC();
    
    UpdateData(false);

    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdGetNewsID.EnableWindow(true);
        goto END;
    }
    
    vnResultCode = FK_GetUserNewsID(gnCommHandleIndex,m_vnEnrollNumber,&m_vnNewsID);
    if(vnResultCode == RUN_SUCCESS)
        m_strMessage = "Get User News ID OK";
    else
        m_strMessage = ReturnResultPrint(vnResultCode);
END:
    FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdGetNewsID.EnableWindow(true);
	UpdateData(false);
}

void CUserInfoDlg::OnSetallnews() 
{
	// TODO: Add your control notification handler code here	
    long vnResultCode;
 
    UpdateData(true);
    m_cmdSetAllNews.EnableWindow(false);
    m_strMessage = "Working...";
    MULTIPROC();
    
    UpdateData(false);

    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if (vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdSetAllNews.EnableWindow(true);
        goto END;
    }
    
	m_vnEnrollNumber = 0;    
    vnResultCode = FK_SetUserNewsID(gnCommHandleIndex,m_vnEnrollNumber,m_vnNewsID);
    if(vnResultCode == RUN_SUCCESS)
        m_strMessage = "Set All User News OK";
    else
        m_strMessage = ReturnResultPrint(vnResultCode);

END:
    FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdSetAllNews.EnableWindow(true);
	UpdateData(false);
}

#define NAMESIZE		400
void CUserInfoDlg::OnClearnews() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;
	long glngUserName[NAMESIZE];

    UpdateData(true);
    m_cmdSetAllNews.EnableWindow(false);
    m_strMessage = "Working...";
    MULTIPROC();
    
    UpdateData(false);
    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdClearNews.EnableWindow(true);
        goto END;
	}

    vnResultCode = FK_SetNewsMessage(gnCommHandleIndex, 255, (char*)glngUserName);
    if(vnResultCode == RUN_SUCCESS)
        m_strMessage = "Clear All New Message OK";
    else
        m_strMessage = ReturnResultPrint(vnResultCode);

END:
    FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdClearNews.EnableWindow(true);
	UpdateData(false);
}

void CUserInfoDlg::OnClearnewsid() 
{
	// TODO: Add your control notification handler code here
	long vnEnrollNumber;
	long vnNewsID;
    long vnResultCode;
    
    UpdateData(true);
    m_cmdClearNewsID.EnableWindow(false);
    m_strMessage = "Working...";
    MULTIPROC();
    
    UpdateData(false);

    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS )
	{
        m_strMessage = gstrNoDevice;
        m_cmdClearNewsID.EnableWindow(true);
        goto END;
    }
    
	vnEnrollNumber =0;
	vnNewsID=255;
    vnResultCode = FK_SetUserNewsID(gnCommHandleIndex,vnEnrollNumber,vnNewsID);

    if(vnResultCode = RUN_SUCCESS)
        m_strMessage = "Clear User News OK";
    else
        m_strMessage = ReturnResultPrint(vnResultCode);
END:
    FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdClearNewsID.EnableWindow(true);
	UpdateData(false);
}

void CUserInfoDlg::OnDeletenewsid() 
{
	// TODO: Add your control notification handler code here
    long vnResultCode;    
 
    UpdateData(true);
    m_cmdDeleteNewsID.EnableWindow(false);
    m_strMessage = "Working...";
    MULTIPROC();
    
	UpdateData(false);
    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdDeleteNewsID.EnableWindow(true);
        goto END;
	}
    
    vnResultCode = FK_SetUserNewsID(gnCommHandleIndex,m_vnEnrollNumber,255);
    if(vnResultCode = RUN_SUCCESS)
        m_strMessage = "Set User News OK";
    else
        m_strMessage = ReturnResultPrint(vnResultCode);
    
END:
    FK_EnableDevice(gnCommHandleIndex, 1);
    m_cmdDeleteNewsID.EnableWindow(true);
	UpdateData(false);
}

void CUserInfoDlg::OnSetcompanyname() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;
    
 	UpdateData(true);
    m_cmdSetCompanyName.EnableWindow(false);
    m_strMessage = "Working...";
    MULTIPROC();

    UpdateData(false);

    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdSetCompanyName.EnableWindow(true);
        goto END;
    }
    
	m_strMessageTool.TrimLeft();
	m_strMessageTool.TrimRight();

    vnResultCode = FK_SetNewsMessage(gnCommHandleIndex, 0, (LPSTR)m_strMessageTool.operator LPCTSTR());
    if(vnResultCode == RUN_SUCCESS)
        m_strMessage = "Set Company Name OK";
    else
        m_strMessage = ReturnResultPrint(vnResultCode);
    
END:
    FK_EnableDevice (gnCommHandleIndex, 1);
    m_cmdSetCompanyName.EnableWindow(true);
	UpdateData(false);
}

void CUserInfoDlg::OnDeletecompanyname() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;
    
	UpdateData(true);
    m_cmdDeleteCompanyName.EnableWindow(false);
    m_strMessage = "Working...";
    MULTIPROC();

    UpdateData(false);

    vnResultCode = FK_EnableDevice(gnCommHandleIndex, 0);
    if(vnResultCode != RUN_SUCCESS )
	{
        m_strMessage = gstrNoDevice;
        m_cmdDeleteCompanyName.EnableWindow(true);
        goto END;
    }

    m_strMessageTool = "";
    vnResultCode = FK_SetNewsMessage(gnCommHandleIndex,0, (LPSTR)m_strMessageTool.operator LPCTSTR());
    if(vnResultCode == RUN_SUCCESS)
        m_strMessage = "Delete Company Name OK";
    else
        m_strMessage = ReturnResultPrint(vnResultCode);
END:
    FK_EnableDevice (gnCommHandleIndex, 1);
    m_cmdDeleteCompanyName.EnableWindow(true);
	UpdateData(false);
}

BOOL CUserInfoDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
    FK_SetFontName( gnCommHandleIndex, CHINA_FONTNAME, 1 );
//	FK_SetFontName( gnCommHandleIndex, JAPAN_FONTNAME, 2 );
//  FK_SetFontName( gnCommHandleIndex, THAI_FONTNAME, 3 );	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
