/************************************************************************
 *                                                                      *
 *  Program : FKDefine.h                                                *
 *                                                                      *
 *  Purpose : Define Header For beSeen Fingerkeeper 6.0 family.          *
 *                                                                      *
 *  Compile : Microsoft Visual C++ .NET                                 *
 *                                                                      *
 *  Version : 2.40                                                      *
 *                                                                      *
 *  Create  : 2008/03/12 Wednesday        -Ver1.00-    By beSeen         *
 *  Update  : 2008/04/22 Tuesday          -Ver1.01-    By beSeen         *
 *  Update  : 2008/05/05 Monday           -Ver2.00-    By beSeen         *
 *  Update  : 2008/05/19 Monday           -Ver2.10-    By beSeen         *
 *  Update  : 2008/05/28 Monday           -Ver2.20-    By beSeen         *
 *  Update  : 2008/07/22 Tuesday          -Ver2.40-    By beSeen         *
 *  Update  : 2008/11/20 Thursday         -Ver2.44-    By beSeen         *
 *  Update  : 2008/11/20 Thursday         -Ver2.44-    By beSeen         *
 *                                                                      *
 *  Copyright (C) 2008  beSeen Electronic Technology Co.,Ltd.            *
 *     All Rights Reserved.                                             *
 *                                                                      *
 ************************************************************************/

#ifndef _INC_FKDEFINEINFO
#define _INC_FKDEFINEINFO

/******************************************************************/
/*                       Bell   Structure                         */
/******************************************************************/
#define MAX_BELLCOUNT_DAY  24
typedef struct tagBELLINFO {
    BYTE    mValid[MAX_BELLCOUNT_DAY];
    BYTE    mHour[MAX_BELLCOUNT_DAY];
    BYTE    mMinute[MAX_BELLCOUNT_DAY];
} BELLINFO;


///////////  Bell Control ///////////
#define MAX_BELLCOUNT			15      // Max Bell count
#define MAX_BELLCOUNT_WEEK		7

#define	BELLKIND_NONE			0
#define	BELLKIND_BUZZER			1
#define	BELLKIND_BELL			2
#define	BELLKIND_BUZZERBELL		3

/*--- Bell Time Infomation ---*/
typedef struct tagBELLTIMEINFO1 {
	unsigned char	Mark;
	unsigned char	WeekDay;
	unsigned char	Reserve[2];
	unsigned char	Valid[MAX_BELLCOUNT_DAY];
	unsigned char	Hour[MAX_BELLCOUNT_DAY];
	unsigned char	Minute[MAX_BELLCOUNT_DAY];
	unsigned char	BellKind[MAX_BELLCOUNT_DAY];
} BELLTIMEINFO1;				/* 100byte	*/

/*--- Bell Infomation ---*/
typedef struct tagBELLINFO1 {
	unsigned char	BellHoldTime;
	unsigned char	Reserve[3];
	BELLTIMEINFO1	BellTime[MAX_BELLCOUNT_WEEK];
} BELLINFO1;					/* 704byte    */

/******************************************************************/
/*                             Structure                          */
/******************************************************************/

#define MAX_PASSCTRLGROUP_COUNT  50
#define MAX_PASSCTRL_COUNT        7 // Pass Count Max Value
typedef struct tagPASSTIME {
    BYTE    StartHour;          	// Door open enable start time(hour)
    BYTE    StartMinute;            // Door open enable start time(minute)
    BYTE    EndHour;                // Door open enable end time(hour)
    BYTE    EndMinute;              // Door open enable end time(minute)
} PASSTIME;

typedef struct tagPASSCTRLTIME {
    PASSTIME    mPassCtrlTime[MAX_PASSCTRL_COUNT];
} PASSCTRLTIME;

#define MAX_USERPASSINFO_COUNT    3
typedef struct tagUSERPASSINFO {
    BYTE   UserPassID[MAX_USERPASSINFO_COUNT];
} USERPASSINFO;

#define MAX_GROUPPASSKIND_COUNT   5
#define MAX_GROUPPASSINFO_COUNT   3
typedef struct tagGROUPPASSINFO {
    BYTE   GroupPassID[MAX_GROUPPASSINFO_COUNT];
} GROUPPASSINFO;

#define MAX_GROUPMATCHINFO_COUNT  10
typedef struct tagGROUPMATCHINFO {
    WORD  GroupMatch[MAX_GROUPMATCHINFO_COUNT];
} GROUPMATCHINFO;
/******************************************************************/
/*                            Constant                            */
/******************************************************************/
//=============== Protocol Type ===============//
#define PROTOCOL_TCPIP             0    // TCP/IP
#define PROTOCOL_UDP               1    // UDP

//=============== Backup Number Constant ===============//
#define BACKUP_FP_0                0    // Finger 0
#define BACKUP_FP_1                1    // Finger 1
#define BACKUP_FP_2                2    // Finger 2
#define BACKUP_FP_3                3    // Finger 3
#define BACKUP_FP_4                4    // Finger 4
#define BACKUP_FP_5                5    // Finger 5
#define BACKUP_FP_6                6    // Finger 6
#define BACKUP_FP_7                7    // Finger 7
#define BACKUP_FP_8                8    // Finger 8
#define BACKUP_FP_9                9    // Finger 9
#define BACKUP_PSW                10    // Password
#define BACKUP_CARD               11    // Card

//=============== Manipulation of SuperLogData ===============//
#define LOG_ENROLL_USER            3    // Enroll-User
#define LOG_ENROLL_MANAGER         4    // Enroll-Manager
#define LOG_ENROLL_DELFP           5    // FP Delete
#define LOG_ENROLL_DELPASS         6    // Pass Delete
#define LOG_ENROLL_DELCARD         7    // Card Delete
#define LOG_LOG_ALLDEL             8    // LogAll Delete
#define LOG_SETUP_SYS              9    // Setup Sys
#define LOG_SETUP_TIME            10    // Setup Time
#define LOG_SETUP_LOG             11    // Setup Log
#define LOG_SETUP_COMM            12    // Setup Comm
#define LOG_PASSTIME              13    // Pass Time Set
#define LOG_SETUP_DOOR            14    // Door Set Log

//=============== VerifyMode of GeneralLogData ===============//
#define LOG_FPVERIFY               1    // Fp Verify
#define LOG_PASSVERIFY             2    // Pass Verify
#define LOG_CARDVERIFY             3    // Card Verify
#define LOG_FPPASS_VERIFY          4    // Pass+Fp Verify
#define LOG_FPCARD_VERIFY          5    // Card+Fp Verify
#define LOG_PASSFP_VERIFY          6    // Pass+Fp Verify
#define LOG_CARDFP_VERIFY          7    // Card+Fp Verify
#define LOG_OPEN_DOOR             10    // Door Open
#define LOG_CLOSE_DOOR            11    // Door Close
#define LOG_OPEN_HAND             12    // Hand Open
#define LOG_OPEN_THREAT           13    // Door Open threat
#define LOG_PROG_OPEN             14    // PC   Open
#define LOG_PROG_CLOSE            15    // PC   Close
#define LOG_OPEN_IREGAL           16    // Iregal Open
#define LOG_CLOSE_IREGAL          17    // Iregal Close
#define LOG_OPEN_COVER            18    // Cover Open
#define LOG_CLOSE_COVER           19    // Cover Close

//=============== IOMode of GeneralLogData ===============//
#define LOG_IOMODE_IN              0
#define LOG_IOMODE_OUT             1
#define LOG_IOMODE_OVER_IN         2
#define LOG_IOMODE_OVER_OUT        3

//=============== Machine Privilege ===============//
#define MP_NONE                    0    // General user
#define MP_ALL                     1    // Manager

//=============== Index of  GetDeviceStatus ===============//
#define	GET_MANAGERS               1
#define	GET_USERS                  2
#define	GET_FPS                    3
#define	GET_PSWS                   4
#define	GET_SLOGS                  5
#define	GET_GLOGS                  6
#define	GET_ASLOGS                 7
#define	GET_AGLOGS                 8
#define	GET_CARDS                  9

//=============== Index of  GetDeviceInfo ===============//
#define DI_MANAGERS                1    // Numbers of Manager
#define DI_LANGAUGE                3    // Language
#define DI_POWEROFF_TIME           4    // Auto-PowerOff Time
#define DI_LOCK_CTRL               5    // Lock Control
#define DI_GLOG_WARNING            6    // General-Log Warning
#define DI_SLOG_WARNING            7    // Super-Log Warning
#define DI_VERIFY_INTERVALS        8    // Verify Interval Time
#define DI_RSCOM_BPS               9    // Comm Buadrate
#define DI_DATE_SEPARATE          10    // Date Separate Symbol
#define DI_VERIFY_KIND            24    // VerrifyKind
#define DI_MULTIUSERS		      77    // MultiUser

//=============== Baudrate = value of DI_RSCOM_BPS ===============//
#define BPS_9600                   3
#define BPS_19200                  4
#define BPS_38400                  5
#define BPS_57600                  6
#define BPS_115200                 7

//=============== Product Data Index ===============//
#define PRODUCT_SERIALNUMBER       1    // Serial Number
#define PRODUCT_BACKUPNUMBER       2    // Backup Number
#define PRODUCT_CODE               3    // Product code
#define PRODUCT_NAME               4    // Product name
#define PRODUCT_WEB                5    // Product web
#define PRODUCT_DATE               6    // Product date
#define PRODUCT_SENDTO             7    // Product sendto

//=============== Door Status ===============//
#define DOOR_CONTROLRESET           0
#define DOOR_OPEND                 1
#define DOOR_CLOSED                2
#define DOOR_COMMNAD               3

//=============== Error code ===============//
#define RUN_SUCCESS                1    // Successful
#define RUNERR_NOSUPPORT           0    // No support
#define RUNERR_UNKNOWNERROR       -1    // Unknown error
#define RUNERR_NO_OPEN_COMM       -2    // No Open Comm
#define RUNERR_WRITE_FAIL         -3    // Write Error
#define RUNERR_READ_FAIL          -4    // Read Error
#define RUNERR_INVALID_PARAM      -5    // Parameter Error
#define RUNERR_NON_CARRYOUT       -6    // execution of command failed.
#define RUNERR_DATAARRAY_END      -7    // End of  data array
#define RUNERR_DATAARRAY_NONE     -8    // None of  data array
#define RUNERR_MEMORY             -9    // Memory Allocating Error
#define RUNERR_MIS_PASSWORD      -10    // mistake password
#define RUNERR_MEMORYOVER        -11    // full enrolldata & can`t put enrolldata
#define RUNERR_DATADOUBLE        -12    // this ID is already  existed.
#define RUNERR_MANAGEROVER       -14    // full manager & can`t put manager
#define RUNERR_FPDATAVERSION     -15    // mistake fp data version.

#endif //!_INC_FKDEFINEINFO
/************************************************************************
 *                                                                      *
 *                        End of file : FKDefine.h                      *
 *                                                                      *
 ************************************************************************/
