// EnrollDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FKAttendOcxSample.h"
#include "MainDlg.h"
#include "EnrollDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEnrollDlg dialog

#define DATASIZE	459
#define DATASIZE_BYTE	459*5
BOOL gbGetState;
long gvnPassWord;
long gvpFpData[DATASIZE];
BYTE gvpFpDataByte[DATASIZE_BYTE];

extern CMainDlg m_MainDlg;
extern CString ReturnResultPrint(long anResultCode);
extern long gnCommHandleIndex;
extern BOOL gbOpenFlag;

CEnrollDlg::CEnrollDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEnrollDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEnrollDlg)
	m_vnEnrollNumber = 1;
	m_strMessage = _T("Message");
	m_strUserName = _T("");
	m_strEnrollData = _T("");
	m_strTotal = _T("");
	m_strDBCount = _T("");
	//}}AFX_DATA_INIT

	m_vnPos=0;
	m_pConnection = NULL;
	m_pRecordset=NULL;	
	m_pRecordset.CreateInstance(__uuidof(Recordset));
}


void CEnrollDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEnrollDlg)
	DDX_Control(pDX, IDB_MODifYPRIVILEG, m_cmdModifyPri);
	DDX_Control(pDX, IDC_PRIVILEG_COMB, m_cmbPrivilege);
	DDX_Control(pDX, IDL_DATALIST, m_lstDataView);
	DDX_Control(pDX, IDC_BACKUPNUMBER_COMB, m_cmbBackupNumber);
	DDX_Control(pDX, IDB_SETENROLLDATA, m_cmdSetEnrollData);
	DDX_Control(pDX, IDB_SETALLENROLL_USB, m_cmdSetAllEnrollDataUSB);
	DDX_Control(pDX, IDB_SETALLENROLL, m_cmdSetAllEnrollData);
	DDX_Control(pDX, IDB_GETENROLLINFO, m_cmdGetEnrollInfo);
	DDX_Control(pDX, IDB_GETENROLLDATA, m_cmdGetEnrollData);
	DDX_Control(pDX, IDB_GETALLENROLL, m_cmdGetAllEnrollData);
	DDX_Control(pDX, IDB_GETALLENROLL_USB, m_cmdGetAllEnrollDataUSB);
	DDX_Control(pDX, IDB_ENABLEUSER, m_cmdEnableUser);
	DDX_Control(pDX, IDB_EMPTYENROLLDATA, m_cmdEmptyEnrollData);
	DDX_Control(pDX, IDB_DIABLEUSER, m_cmdDisableUser);
	DDX_Control(pDX, IDB_DELETEENROLLDATA, m_cmdDeleteEnrollData);
	DDX_Control(pDX, IDB_DELETEDB, m_cmdDeleteDB);
	DDX_Control(pDX, IDB_BENUMBALLMANAGER, m_cmdBenrmbAllManager);
	DDX_Control(pDX, IDB_CEMPTY, m_cmdClearEmpty);
	DDX_Text(pDX, IDE_ENROLLNUMBER, m_vnEnrollNumber);
	DDX_Text(pDX, IDT_MESSAGE, m_strMessage);
	DDX_Text(pDX, IDE_USERNAME, m_strUserName);
	DDX_Text(pDX, IDT_ENROLLDATA, m_strEnrollData);
	DDX_Text(pDX, IDT_TOTAL, m_strTotal);
	DDX_Text(pDX, IDE_DBCOUNT, m_strDBCount);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEnrollDlg, CDialog)
	//{{AFX_MSG_MAP(CEnrollDlg)
	ON_BN_CLICKED(IDB_GETENROLLINFO, OnGetenrollinfo)
	ON_BN_CLICKED(IDB_ENABLEUSER, OnEnableuser)
	ON_BN_CLICKED(IDB_DIABLEUSER, OnDiableuser)
	ON_BN_CLICKED(IDB_BENUMBALLMANAGER, OnBenumballmanager)
	ON_BN_CLICKED(IDB_EMPTYENROLLDATA, OnEmptyenrolldata)
	ON_BN_CLICKED(IDB_CEMPTY, OnCempty)
	ON_BN_CLICKED(IDB_GETENROLLDATA, OnGetenrolldata)
	ON_BN_CLICKED(IDB_SETENROLLDATA, OnSetenrolldata)
	ON_BN_CLICKED(IDB_DELETEENROLLDATA, OnDeleteenrolldata)
	ON_BN_CLICKED(IDB_DELETEDB, OnDeletedb)
	ON_BN_CLICKED(IDB_GETALLENROLL, OnGetallenroll)
	ON_BN_CLICKED(IDB_SETALLENROLL, OnSetallenroll)
	ON_BN_CLICKED(IDB_GETALLENROLL_USB, OnGetallenrollUsb)
	ON_BN_CLICKED(IDB_SETALLENROLL_USB, OnSetallenrollUsb)
	ON_BN_CLICKED(IDB_MODifYPRIVILEG, OnMODifYPRIVILEG)
	ON_NOTIFY(UDN_DELTAPOS, IDC_POSITION_SPIN, OnDeltaposPositionSpin)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEnrollDlg message handlers

BOOL CEnrollDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	if(m_vbDataBaseFlag==TRUE)
	{
		if(m_pRecordset!=NULL || m_pRecordset->State)
		{
			m_pRecordset->Close();
			m_pRecordset=NULL;
		}
		if(m_pConnection!= NULL || m_pConnection->State)
		{
			m_pConnection->Close();
			m_pConnection= NULL;
		}
	}
	::ShowWindow(AfxGetApp()->GetMainWnd()->m_hWnd,SW_SHOW);
	return CDialog::DestroyWindow();
}

BOOL CEnrollDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CString vStr;
	CString fcstrCnn40;
	long vnEnrollNumber=0;
	long vnBackupNumber=0;
	long vnPrivilege=0;
	long vnRecordCount=0, vnPos=0;
	CString vstrEnrollName="";



	fcstrCnn40 = "Provider=Microsoft.Jet.OLEDB.4.0;Persist Security Info=False;Data Source=";
	m_vbDataBaseFlag=FALSE;
	gbGetState=FALSE;
	
	// TODO: Add extra initialization here

	m_cmbBackupNumber.AddString("Fp-0");
	m_cmbBackupNumber.AddString("Fp-1");
	m_cmbBackupNumber.AddString("Fp-2");
	m_cmbBackupNumber.AddString("Fp-3");
	m_cmbBackupNumber.AddString("Fp-4");
	m_cmbBackupNumber.AddString("Fp-5");
	m_cmbBackupNumber.AddString("Fp-6");
	m_cmbBackupNumber.AddString("Fp-7");
	m_cmbBackupNumber.AddString("Fp-8");
	m_cmbBackupNumber.AddString("Fp-9");
	m_cmbBackupNumber.AddString("Pass");
	m_cmbBackupNumber.AddString("Card");
	m_cmbBackupNumber.SetCurSel(0);


	m_cmbPrivilege.AddString("User");
	m_cmbPrivilege.AddString("Manager");
	m_cmbPrivilege.SetCurSel(0);

	m_lstDataView.ResetContent();

	char lpStr[256];
	GetCurrentDirectory(256,lpStr);
	m_strDBPath.Format("%s", lpStr);
	m_strDBPathName.Format("%s\\datEnrollDat.mdb", lpStr);	
	CFile file;
	if(!file.Open(m_strDBPathName.operator LPCTSTR(), CFile::modeReadWrite))
	{
		CString strFilter;
		strFilter = "DB Files (*.mdb)|*.mdb|All Files (*.*)|*.*";
		CFileDialog dlgOpen(TRUE, NULL, NULL, OFN_HIDEREADONLY, strFilter);
        if(dlgOpen.DoModal()==IDOK)		
			m_strDBPathName = dlgOpen.GetPathName();		
		if (m_strDBPathName.GetLength()<0)		
			goto END;
	}
	else
		file.Close();
	vStr.Format("%s%s",fcstrCnn40,m_strDBPathName);

	//AfxOleInit();
	m_pConnection.CreateInstance(__uuidof(Connection));
	try                 
	{
		TCHAR AdoConnStr[512];
		memset(AdoConnStr,0,512);
		wsprintf (AdoConnStr, _T("%s%s"),fcstrCnn40, m_strDBPathName);
		_bstr_t	bstrADOConn=AdoConnStr;
		m_pConnection->Open(bstrADOConn,"","",adModeUnknown);		
	}
	catch(_com_error e)
	{
		AfxMessageBox("Database can not Open!");
		m_pConnection= NULL;		
		return FALSE;
	}

	m_vnDatabaseCount=OpenDataBase();
	if(m_vnDatabaseCount<0) m_vnDatabaseCount=0;
	if(m_vnDatabaseCount>=1)
	{
		m_vbDataBaseFlag=TRUE;
		while(!m_pRecordset->adoEOF)
		{
			FuncReadFromToDB(&vnEnrollNumber,
				             &vnBackupNumber,
							 &vnPrivilege,
							 vstrEnrollName,
							 TRUE);
			
			m_pRecordset->MoveNext();
			m_vnPos++;		
			UpdateData(FALSE);
		}
	}

	DBWithItemEnable(TRUE);

END:
	m_strDBCount.Format("%d/%d", m_vnPos, m_vnDatabaseCount);
	if(gbOpenFlag==FALSE)
	{
		DisableButtons();
	}	
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BEGIN_EVENTSINK_MAP(CEnrollDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CEnrollDlg)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()


void CEnrollDlg::CloseDataBase(void)
{
	m_pRecordset->Close();
	m_pRecordset=NULL;
}
long CEnrollDlg::OpenDataBase(void)
{
	long vnRet=0;

	if(m_pRecordset==NULL)
		m_pRecordset.CreateInstance(__uuidof(Recordset));
	if(m_pRecordset->State)
		m_pRecordset->Close();
	
	try
	{
		m_pRecordset->Open("select * FROM tblEnroll",
			                m_pConnection.GetInterfacePtr(),
							adOpenDynamic,
							adLockOptimistic,
							adCmdText);
	}
	catch(_com_error *e)
	{
		return -1;
	}


	while(!m_pRecordset->adoEOF)
	{
	
		vnRet++;
		m_pRecordset->MoveNext();
	}
	
	if(!m_pRecordset->BOF)
		m_pRecordset->MoveFirst();
	else
		return -1;
	return vnRet;

}

long CEnrollDlg::GetDatabaseCount()
{
	long vnDataCount=0;

	if(OpenDataBase()==-1)
	{
		m_vnDatabaseCount=0;
		return vnDataCount;
	}

	while(!m_pRecordset->adoEOF)
	{
		vnDataCount++;
		m_pRecordset->MoveNext();		
	}
	CloseDataBase();
	return vnDataCount;
}
long CEnrollDlg::GetFindData(long anEnrollNumber, long anBackupNumber)
{
	long vnRet=-1;
	long vnEnrollNumber, vnBackupNumber;

	if(m_vnDatabaseCount>=1)
		m_pRecordset->MoveFirst();
	while(!m_pRecordset->adoEOF)
	{
		vnEnrollNumber = (long)(m_pRecordset->GetCollect("EnrollNumber"));
		vnBackupNumber = (long)(m_pRecordset->GetCollect("FingerNumber"));
		if((vnEnrollNumber!=0 && vnEnrollNumber==anEnrollNumber) && vnBackupNumber==anBackupNumber)
		{
			vnRet=1;
			break;
		}
		m_pRecordset->MoveNext();
	}
	return vnRet;
}
long CEnrollDlg::FuncSaveToDB(long anEnrollNumber, long anBackupNumber, long anPrivilege, CString anEnrollName)
{
	long i=0, vnLen=0;
	long vnEMachineNumber=0;
	long vnFindCount=0;
	
	vnFindCount=GetFindData(anEnrollNumber, anBackupNumber);

	if(vnFindCount>=1)	
		return 2;
	else
	{
		long vnCount=0;
		
		m_pRecordset->AddNew();
		m_pRecordset->PutCollect("EMachineNumber",_variant_t(vnEMachineNumber));
		m_pRecordset->PutCollect("EnrollNumber",_variant_t(anEnrollNumber));
		m_pRecordset->PutCollect("FingerNumber", _variant_t(anBackupNumber));
		m_pRecordset->PutCollect("Privilige", _variant_t(anPrivilege));
		m_pRecordset->PutCollect("EnrollName", _variant_t(anEnrollName));
		if(anBackupNumber == BACKUP_PSW)
			m_pRecordset->PutCollect("Password", _variant_t(gvnPassWord));
		
		else if(anBackupNumber == BACKUP_CARD)
			m_pRecordset->PutCollect("Password", _variant_t(gvnPassWord));
		else
		{
			vnLen=DATASIZE;
			for(i=0;i<vnLen; i++)
			{
				gvpFpDataByte[i*5] = 1;
				if(gvpFpData[i] < 0 )
				{
					gvpFpDataByte[i*5] = 0;
					gvpFpData[i]= abs(gvpFpData[i]);
				}
				gvpFpDataByte[i*5+1] = (gvpFpData[i] / 256 / 256 / 256);
				gvpFpDataByte[i*5+2] = (gvpFpData[i] / 256 / 256) % 256;
				gvpFpDataByte[i*5+3] = (gvpFpData[i] / 256) % 256;
				gvpFpDataByte[i*5+4] = (gvpFpData[i]) % 256;
			}
			
			SAFEARRAYBOUND rgsabound;
			rgsabound.lLbound = 0;
			rgsabound.cElements = DATASIZE_BYTE;
			SAFEARRAY *psa=::SafeArrayCreate(VT_UI1,1,&rgsabound);			
			BYTE *bf=gvpFpDataByte;			
			for(long i=0;i<DATASIZE_BYTE;i++)
				::SafeArrayPutElement(psa,&i,bf++);			
			variant_t data;
			data.vt=VT_ARRAY|VT_UI1;
			data.parray=psa;
			m_pRecordset->PutCollect("FPdata",data);
			::SafeArrayDestroyData(psa);			
			
		}
		FuncDispToListBox(anEnrollNumber);			
		m_pRecordset->Update();
		m_vnDatabaseCount++;		
	}
	return 1;
}


BOOL CEnrollDlg::FuncReadFromToDB(long* anEnrollNumber, long *anBackupNumber,long* anPrivilege, CString& anEnrollName, BOOL abdispFlag)
{
	CString vStr;
	_variant_t vnValue;
	*anEnrollNumber=(long)(m_pRecordset->GetCollect("EnrollNumber"));
	*anBackupNumber=(long)(m_pRecordset->GetCollect("FingerNumber"));
	*anPrivilege=(long)(m_pRecordset->GetCollect("Privilige"));

	anEnrollName="";
	vnValue=m_pRecordset->GetCollect("EnrollName");
	if(vnValue.vt != VT_NULL)
		anEnrollName=(LPCSTR)(_bstr_t)(vnValue);

	gvnPassWord=(long)(m_pRecordset->GetCollect("Password"));
	if(*anBackupNumber<BACKUP_PSW)
	{
		vnValue= m_pRecordset->GetCollect("FPdata");		
		ConvertByteToLongType((BYTE*)vnValue.parray->pvData);

	}
	if (abdispFlag == TRUE)
		FuncDispToListBox(*anBackupNumber);
        

	return TRUE;
}

void CEnrollDlg::FuncDispToListBox(long anBackupNumber)
{
	
	long vnii, vnLen;
	CString vStr;
	m_lstDataView.ResetContent();
	
	m_strEnrollData="Enrolled Data :";
	m_strTotal="";
	

	if(anBackupNumber == BACKUP_PSW)
	{
		vStr.Format("%d", gvnPassWord);
		m_lstDataView.AddString(vStr);
	}
	else if(anBackupNumber == BACKUP_CARD)
	{
		vStr.Format("%d", gvnPassWord);
		m_lstDataView.AddString(vStr);
	}
	else if(anBackupNumber < BACKUP_PSW)
	{
		vnLen = DATASIZE;
		for(vnii = 0; vnii<vnLen ; vnii++)
		{
			vStr.Format("%d", gvpFpData[vnii]);
			m_lstDataView.AddString(vStr);
		}
	}
	
}

void CEnrollDlg::ConvertByteToLongType(BYTE* aBuff)
{
	long vnii;
	long vnLen;
	vnLen = DATASIZE;
	memset(gvpFpData, 0, vnLen *sizeof(long));
	for(vnii = 0; vnii<vnLen ; vnii++)
	{
		gvpFpData[vnii] = aBuff[vnii * 5 + 1];
		gvpFpData[vnii] = gvpFpData[vnii] * 256 + aBuff[vnii * 5 + 2];
		gvpFpData[vnii] = gvpFpData[vnii] * 256 + aBuff[vnii * 5 + 3];
		gvpFpData[vnii] = gvpFpData[vnii] * 256 + aBuff[vnii * 5 + 4];
		if(aBuff[vnii * 5]  == 0)
			gvpFpData[vnii] = 0 - gvpFpData[vnii];
	}
}


void CEnrollDlg::DBWithItemEnable(BOOL abEnableFlag)
{

	m_cmdDeleteDB.EnableWindow(abEnableFlag);
	m_cmdSetAllEnrollData.EnableWindow(abEnableFlag);
	m_cmdGetAllEnrollData.EnableWindow(abEnableFlag);
	m_cmdGetAllEnrollDataUSB.EnableWindow(abEnableFlag);
	m_cmdSetAllEnrollDataUSB.EnableWindow(abEnableFlag);
}

void CEnrollDlg::DisableButtons()
{
	m_cmdGetEnrollData.EnableWindow(FALSE);
	m_cmdSetEnrollData.EnableWindow(FALSE);
	m_cmdDeleteEnrollData.EnableWindow(FALSE);
	m_cmdGetAllEnrollData.EnableWindow(FALSE);
	m_cmdSetAllEnrollData.EnableWindow(FALSE);
	m_cmdGetEnrollInfo.EnableWindow(FALSE);
	m_cmdEnableUser.EnableWindow(FALSE);
	m_cmdDisableUser.EnableWindow(FALSE);
	m_cmdModifyPri.EnableWindow(FALSE);
	m_cmdBenrmbAllManager.EnableWindow(FALSE);
	m_cmdClearEmpty.EnableWindow(FALSE);
	m_cmdEmptyEnrollData.EnableWindow(FALSE);
}



void CEnrollDlg::OnGetenrollinfo() 
{
	// TODO: Add your control notification handler code here
	long vEnrollNumber,vBackupNumber, vPrivilege, vnEnableFlag;
	long vnii, vnResultCode;
	CString vstrBackupNumber,vstrPrivilege,vstrEnableFlag;
	CString vStr;	
	
	m_cmdGetEnrollInfo.EnableWindow(FALSE);

	m_strEnrollData = "User IDs";
	m_lstDataView.ResetContent();
	m_strMessage = "Working...";
	UpdateData(FALSE);
	MULTIPROC();
	
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdGetEnrollInfo.EnableWindow(TRUE);
		goto END;
	}
	
	vnResultCode = m_MainDlg.m_ctrlFkattend.ReadAllUserID();
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = ReturnResultPrint(vnResultCode);
		m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
		m_cmdGetEnrollInfo.EnableWindow(TRUE);
		goto END;
	}
	
	//------ Show all enroll information ----------
	vStr.Format(" No.     EnNo    Fp   Priv Enable");
	m_lstDataView.AddString(vStr);	
	vnii = 0;	
	while(vnResultCode != RUNERR_DATAARRAY_END)
	{
		vnResultCode = m_MainDlg.m_ctrlFkattend.GetAllUserID( &vEnrollNumber, &vBackupNumber, &vPrivilege, &vnEnableFlag);
		if(vnResultCode != RUN_SUCCESS)
		{
			if(vnResultCode == RUNERR_DATAARRAY_END)
			{
				vnResultCode = RUN_SUCCESS;
				break;
			}
		}
			
		if(vPrivilege == MP_ALL)
			vstrPrivilege = "Man";
		else
			vstrPrivilege = "User";		
		m_cmbBackupNumber.GetLBText(m_cmbBackupNumber.SetCurSel(vBackupNumber), vstrBackupNumber);
		if(vnEnableFlag == 1)
			vstrEnableFlag = "E";
		else
			vstrEnableFlag = "D";
		vStr.Format("%04d   %08d  %s  %s %s",vnii, vEnrollNumber, vstrBackupNumber, vstrPrivilege, vstrEnableFlag);
		m_lstDataView.AddString(vStr);	
		
		vnii = vnii + 1;
		vStr.Format("Total : %d",vnii);
		m_strTotal=  vStr;
		MULTIPROC();
		UpdateData(FALSE);
	}	
	
	if(vnResultCode == RUN_SUCCESS)
		m_strMessage = "GetEnrollInfo OK";
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
	

END:	
	m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
    m_cmdGetEnrollInfo.EnableWindow(TRUE);
	UpdateData(FALSE);
}


void CEnrollDlg::FuncSetUserEnableStatus(BOOL abEnableFlag)
{
	long vEnrollNumber;
	long vBackupNumber;
	long vnResultCode;

	MULTIPROC();

	UpdateData(TRUE);
	vEnrollNumber = m_vnEnrollNumber;
	vBackupNumber = m_cmbBackupNumber.GetCurSel();

	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		goto END;

	}

	m_strMessage = "Working...";
	UpdateData(FALSE);
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableUser(vEnrollNumber, vBackupNumber, abEnableFlag);
	m_strMessage = ReturnResultPrint(vnResultCode);
END:							 
	m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
	UpdateData(FALSE);
}
void CEnrollDlg::OnEnableuser() 
{
	// TODO: Add your control notification handler code here
	m_cmdEnableUser.EnableWindow(FALSE);
	FuncSetUserEnableStatus( TRUE);
    m_cmdEnableUser.EnableWindow(TRUE);
}

void CEnrollDlg::OnDiableuser() 
{
	// TODO: Add your control notification handler code here
	m_cmdDisableUser.EnableWindow(FALSE);
	FuncSetUserEnableStatus( FALSE);
    m_cmdDisableUser.EnableWindow(TRUE);
}

void CEnrollDlg::OnModifyPrivileg() 
{
	// TODO: Add your control notification handler code here

}

void CEnrollDlg::OnBenumballmanager() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;
		
	m_cmdBenrmbAllManager.EnableWindow(FALSE);
	m_strMessage = "Working...";
	UpdateData(FALSE);
	MULTIPROC();
	
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdBenrmbAllManager.EnableWindow(TRUE);
		goto END;
	}
	
	vnResultCode = m_MainDlg.m_ctrlFkattend.BenumbAllManager();
	m_strMessage = ReturnResultPrint(vnResultCode);

END:	
	m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
    m_cmdBenrmbAllManager.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CEnrollDlg::OnEmptyenrolldata() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;

	m_cmdEmptyEnrollData.EnableWindow(FALSE);
	m_strMessage = "Working...";
	UpdateData(FALSE);
	MULTIPROC();
	
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdEmptyEnrollData.EnableWindow(TRUE);
		goto END;
	}
	
	vnResultCode = m_MainDlg.m_ctrlFkattend.EmptyEnrollData();
	m_strMessage = ReturnResultPrint(vnResultCode);

END:
	m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
	m_cmdEmptyEnrollData.EnableWindow(TRUE);
    UpdateData(FALSE);
}

void CEnrollDlg::OnCempty() 
{
	// TODO: Add your control notification handler code here
	long vnResultCode;
		
	m_cmdClearEmpty.EnableWindow(FALSE);
	m_strMessage = "Working...";
	UpdateData(FALSE);
	MULTIPROC();
	
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdClearEmpty.EnableWindow(TRUE);
		goto END;
	}
	
	vnResultCode = m_MainDlg.m_ctrlFkattend.ClearKeeperData();
	if(vnResultCode == RUN_SUCCESS)
		m_strMessage = "ClearKeeperData OK";
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
	
END:
	m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
    m_cmdClearEmpty.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CEnrollDlg::OnGetenrolldata() 
{
	// TODO: Add your control notification handler code here
	long vEnrollNumber;
	long vBackupNumber;
	long vPrivilege;
	long vnResultCode;
	
	m_cmdGetEnrollData.EnableWindow(FALSE);	
	m_lstDataView.ResetContent();
	MULTIPROC();
	
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdGetEnrollData.EnableWindow(TRUE);
		goto END;
	}
	
	UpdateData(TRUE);
	vEnrollNumber = m_vnEnrollNumber;
	vBackupNumber = m_cmbBackupNumber.GetCurSel();

	m_strMessage = "Working...";
	UpdateData(FALSE);
	
	vnResultCode = m_MainDlg.m_ctrlFkattend.GetEnrollData( vEnrollNumber, vBackupNumber, &vPrivilege, &gvpFpData[0], &gvnPassWord);
	if(vnResultCode == RUN_SUCCESS)
	{
		if(vPrivilege == MP_ALL)
			m_cmbPrivilege.SetCurSel(1);
		else
			m_cmbPrivilege.SetCurSel(0);
		
		
		FuncDispToListBox(vBackupNumber);
		m_strMessage = "GetEnrollData OK";
	}
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
	
END:
	m_MainDlg.m_ctrlFkattend.EnableDevice( 1) ;
    m_cmdGetEnrollData.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CEnrollDlg::OnSetenrolldata() 
{
	// TODO: Add your control notification handler code here
	long vEnrollNumber;
	long vBackupNumber;
	long vPrivilege;
	long vnResultCode;
		
	m_cmdSetEnrollData.EnableWindow(FALSE);
	MULTIPROC();

	UpdateData(TRUE);
	vEnrollNumber = m_vnEnrollNumber;
	vBackupNumber = m_cmbBackupNumber.GetCurSel();
	if(m_cmbPrivilege.GetCurSel()==1)
        vPrivilege = MP_ALL;
	else
        vPrivilege = MP_NONE;

	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdSetEnrollData.EnableWindow(TRUE);
		goto END;
	}
	
	m_strMessage = "Working...";
	UpdateData(FALSE);
	vnResultCode = m_MainDlg.m_ctrlFkattend.PutEnrollData( vEnrollNumber, vBackupNumber, vPrivilege, &gvpFpData[0], gvnPassWord);
	if(vnResultCode == RUN_SUCCESS)
	{
        m_strMessage = "Saving...";
        UpdateData(FALSE);
        vnResultCode = m_MainDlg.m_ctrlFkattend.SaveEnrollData();
        if(vnResultCode == RUN_SUCCESS) 
			m_strMessage = "SetEnrollData OK";
		else
			m_strMessage = "SaveEnrollData ERROR";
	}
        
	if(vnResultCode != RUN_SUCCESS)
		m_strMessage = ReturnResultPrint(vnResultCode);
	
END:		
	m_MainDlg.m_ctrlFkattend.EnableDevice( 1) ;
    m_cmdSetEnrollData.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CEnrollDlg::OnDeleteenrolldata() 
{
	// TODO: Add your control notification handler code here
    long vEnrollNumber;
	long vBackupNumber;
	long vnResultCode;
	
	m_cmdDeleteEnrollData.EnableWindow(FALSE);
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdDeleteEnrollData.EnableWindow(TRUE);
		goto END;
	}
	
	UpdateData(TRUE);
	vEnrollNumber = m_vnEnrollNumber;
	vBackupNumber = m_cmbBackupNumber.GetCurSel();
	m_strMessage = "Working...";
	UpdateData(FALSE);
	vnResultCode = m_MainDlg.m_ctrlFkattend.DeleteEnrollData( vEnrollNumber, vBackupNumber);
	if(vnResultCode == RUN_SUCCESS)
		m_strMessage = "DeleteEnrollData OK";
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
END:
	m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
    m_cmdDeleteEnrollData.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CEnrollDlg::OnDeletedb() 
{
	// TODO: Add your control notification handler code here
    m_cmdDeleteDB.EnableWindow(FALSE);	
	MULTIPROC();

	if(m_pRecordset->State)
		m_pRecordset->Close();

	m_pRecordset->Open("delete * from tblEnroll",
						m_pConnection.GetInterfacePtr(),
						adOpenDynamic,
						adLockOptimistic,
						adCmdText);

    m_cmdDeleteDB.EnableWindow(TRUE);
	m_strMessage="DeleteDB OK";
	m_strDBCount="0/0";

	m_vnDatabaseCount=OpenDataBase();
	if(m_vnDatabaseCount<0) m_vnDatabaseCount=0;

	UpdateData(FALSE);
}

void CEnrollDlg::OnMODifYPRIVILEG() 
{
	// TODO: Add your control notification handler code here
	long vEnrollNumber;
	long vBackupNumber;
	long vPrivilege;
	long vnResultCode;
	
	m_cmdModifyPri.EnableWindow(FALSE);	
	MULTIPROC();	
	UpdateData(TRUE);
	vEnrollNumber = m_vnEnrollNumber;
	vBackupNumber = m_cmbBackupNumber.GetCurSel();
	if(m_cmbPrivilege.GetCurSel()==1)
		vPrivilege = MP_ALL;
	else
		vPrivilege = MP_NONE;
	
	
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 0);
	if(vnResultCode != RUN_SUCCESS) 
	{
		m_strMessage = gstrNoDevice;
		m_cmdModifyPri.EnableWindow(TRUE);
		goto END;
	}
	m_strMessage = "Working...";
	UpdateData(FALSE);
	vnResultCode = m_MainDlg.m_ctrlFkattend.ModifyPrivilege( vEnrollNumber, vBackupNumber, vPrivilege);
	m_strMessage = ReturnResultPrint(vnResultCode);
	
END:
	m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
    m_cmdModifyPri.EnableWindow(TRUE);
	UpdateData(FALSE);	
}

void CEnrollDlg::OnGetallenroll() 
{
	// TODO: Add your control notification handler code here

	long vEnrollNumber;
	long vBackupNumber;
	long vPrivilege;
	CString vEnrollName;
	long vnEnableFlag;
	long vnMessRet;
	CString vTitle, vStr;
	long vnResultCode;
	long vnRet=0;
	BSTR vpStrName=NULL;
	
		
	m_cmdGetAllEnrollData.EnableWindow(FALSE);
	m_lstDataView.ResetContent();		
	
	GetDlgItemText(IDD_ENROLLDATA_DIALOG,vTitle );	
	m_strMessage = "Working...";
	MULTIPROC();
		
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdGetAllEnrollData.EnableWindow(TRUE);
		goto END;
	}
		
	vnResultCode = m_MainDlg.m_ctrlFkattend.ReadAllUserID();
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = ReturnResultPrint(vnResultCode);
		m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
		m_cmdGetAllEnrollData.EnableWindow(TRUE);
		goto END;
	}	
	
	//---- Get Enroll data and save into database -------------	
    gbGetState = TRUE;
	m_vnPos=0;
	while (vnResultCode != RUNERR_DATAARRAY_END)
	{
FFF:
		vnResultCode = m_MainDlg.m_ctrlFkattend.GetAllUserID(
									   &vEnrollNumber,
									   &vBackupNumber,
									   &vPrivilege,
									   &vnEnableFlag);
		if(vnResultCode != RUN_SUCCESS)
		{
			if(vnResultCode == RUNERR_DATAARRAY_END)
				vnResultCode = RUN_SUCCESS;
			break;
		}		
EEE:
		vnResultCode = m_MainDlg.m_ctrlFkattend.GetEnrollData(
										vEnrollNumber,
										vBackupNumber,
										&vPrivilege,
										&gvpFpData[0],
										&gvnPassWord);
		
		if(vnResultCode != RUN_SUCCESS)
		{
			vStr.Format("%s : Continue ?", ReturnResultPrint(vnResultCode));
			vnMessRet = MessageBox(vStr, "GetEnrollData",MB_YESNOCANCEL);
			if (vnMessRet == IDYES)
				goto EEE;
			else if(vnMessRet == IDCANCEL)
				break;
			else
				goto FFF;
		
		}	

		vnResultCode = m_MainDlg.m_ctrlFkattend.GetUserName(vEnrollNumber, &vpStrName);
		vEnrollName=vpStrName;
		vnRet=FuncSaveToDB(vEnrollNumber, vBackupNumber, vPrivilege, vEnrollName);
		if(vnRet==ENROLL_SAVEDOUBLE)
			m_strMessage.Format("Double ID : %04d",vEnrollNumber);
		else if(vnRet==ENROLL_SAVEOK)
			m_strMessage.Format("%04d-%d", vEnrollNumber, vBackupNumber);
		else
		{
			vStr.Format("%s : Continue ?", ReturnResultPrint(vnResultCode));
			vnMessRet = MessageBox(vStr, "GetEnrollData",MB_YESNOCANCEL);
			if (vnMessRet == IDYES)
				goto EEE;
			else if(vnMessRet == IDCANCEL)
				break;
			else
				goto FFF;
		}		
		m_vnPos++;
		
		SetDlgItemText(IDD_ENROLLDATA_DIALOG,vStr);
		UpdateData(FALSE);
		MULTIPROC();
	}
	gbGetState = FALSE;
	MULTIPROC();
	
	SetDlgItemText(IDD_ENROLLDATA_DIALOG,vTitle);
	
	if(vnResultCode = RUN_SUCCESS)
		m_strMessage = "GetAllEnrollData OK";
	else
		m_strMessage.Format("GetAllEnrollData Error : %s" ,ReturnResultPrint(vnResultCode));
	
	//m_vnDatabaseCount=m_vnPos;
	m_strDBCount.Format("%d/%d", m_vnPos, m_vnDatabaseCount);
END:
	
	m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
    m_cmdGetAllEnrollData.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CEnrollDlg::OnSetallenroll() 
{
	// TODO: Add your control notification handler code here
	long vEnrollNumber;
	long vBackupNumber;
	long vPrivilege;
	long vnMessRet;
	CString vEnrollName;
	CString vStr;
	CString vTitle;
	long vnResultCode;
	BOOL vbRet;
	

	m_lstDataView.ResetContent();
	m_cmdSetAllEnrollData.EnableWindow(FALSE);	

	m_strMessage= "Working...";
	UpdateData(FALSE);
	MULTIPROC();
	
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 0);
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = gstrNoDevice;
		m_cmdSetAllEnrollData.EnableWindow(TRUE);
		goto END;
	}
	
	gbGetState = TRUE;
	m_vnDatabaseCount= GetDatabaseCount();
	if(m_vnDatabaseCount<0)
	{
		m_strMessage = "Database Error";
		vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
		m_cmdSetAllEnrollData.EnableWindow(TRUE);
		goto END;
	}

	m_vnPos=0;
	if(OpenDataBase()>=1)
	{
		while(!m_pRecordset->adoEOF)
		{
FFF:
			vbRet = FuncReadFromToDB(&vEnrollNumber, &vBackupNumber, &vPrivilege, vEnrollName, FALSE);
			if(vbRet != TRUE)
			{
				vStr = "SetAllEnrollData Error";
				break;
			}
			vnResultCode = m_MainDlg.m_ctrlFkattend.PutEnrollData(
				                            vEnrollNumber,
											vBackupNumber,
											vPrivilege,
											&gvpFpData[0],
											gvnPassWord);
			
			if(vnResultCode != RUN_SUCCESS)
			{
				vStr.Format("%s : Continue ?", ReturnResultPrint(vnResultCode));
				vnMessRet = MessageBox(vStr, "SetEnrollData",MB_YESNOCANCEL);
				if (vnMessRet == IDYES)
					goto FFF;
				else if(vnMessRet == IDCANCEL)
					break;
			}
			vnResultCode = m_MainDlg.m_ctrlFkattend.SetUserName(vEnrollNumber,(LPSTR)(LPCTSTR)vEnrollName);
			if(vnResultCode != RUN_SUCCESS)
			{
				vStr.Format("%s : Continue ?", ReturnResultPrint(vnResultCode));
				vnMessRet = MessageBox(vStr, "UserName",MB_YESNOCANCEL);
				if (vnMessRet == IDYES)
					goto FFF;
				else if(vnMessRet == IDCANCEL)
					break;
			}
			m_vnPos++;
			m_strMessage.Format("ID=%04d, FpNo=%d, Count=%d", vEnrollNumber, vBackupNumber,m_vnPos);
			MULTIPROC();
			m_pRecordset->MoveNext();
			UpdateData(FALSE);
		}
		
		gbGetState = FALSE;
		
		if(vnResultCode == RUN_SUCCESS)
		{
			m_strMessage= "Saving...";
			UpdateData(FALSE);
			MULTIPROC();
			vnResultCode = m_MainDlg.m_ctrlFkattend.SaveEnrollData();
			if(vnResultCode == RUN_SUCCESS)
				m_strMessage= "SetAllEnrollData OK";
			else
				m_strMessage= ReturnResultPrint(vnResultCode);		
		}
		else
			m_strMessage= ReturnResultPrint(vnResultCode);
	}
	else
		m_strMessage= "Database Error";	
    
END:	
	vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
	m_cmdSetAllEnrollData.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CEnrollDlg::OnGetallenrollUsb() 
{
	// TODO: Add your control notification handler code here
	long vEnrollNumber;	
	long vBackupNumber;
	long vPrivilege;
	long vnEnableFlag;
	CString vTitle;
	CString vEnrollName;
	CString vstrFileName;
	long vnResultCode;
	long vnNewsKind;
	WCHAR* vName;
	BSTR vpStrName;
	
	vName=new WCHAR[20];		
	vnNewsKind = NEWS_STANDARD;
	
	CString strFilter;
	strFilter = "DAT Files (*.dat)|*.dat|All Files (*.*)|*.*";
	CFileDialog dlgOpen(TRUE, NULL, NULL, OFN_HIDEREADONLY, strFilter);
    if(dlgOpen.DoModal()==IDOK)		
		vstrFileName = dlgOpen.GetPathName();
	if (vstrFileName == "" )
		goto END;
	
	m_cmdGetAllEnrollDataUSB.EnableWindow(FALSE);
	m_lstDataView.ResetContent();
	m_strMessage = "Working...";
	MULTIPROC();

	m_MainDlg.m_ctrlFkattend.SetUSBModel(FK625_FP2000);

	vnResultCode = m_MainDlg.m_ctrlFkattend.USBReadAllEnrollDataFromFile( (LPSTR)(LPCTSTR)vstrFileName);
	
	if(vnResultCode != RUN_SUCCESS)
	{
		m_strMessage = ReturnResultPrint(vnResultCode);
		m_cmdGetAllEnrollDataUSB.EnableWindow(TRUE);
		goto END;
	}

	//---- Get Enroll data and save into database -------------
    gbGetState = TRUE;
    while (vnResultCode != RUNERR_DATAARRAY_END)
    {
		
		memset(vName, 0, sizeof(WCHAR)*20);
		vpStrName = (BSTR)vName;
		vnResultCode = m_MainDlg.m_ctrlFkattend.USBGetOneEnrollData( 
											  &vEnrollNumber,
											  &vBackupNumber,
											  &vPrivilege,
											  &gvpFpData[0],
											  &gvnPassWord,
											  &vnEnableFlag,
											  &vpStrName);
		if(vnResultCode != RUN_SUCCESS)
		{
			if(vnResultCode = RUNERR_DATAARRAY_END )
				vnResultCode = RUN_SUCCESS;
			break;
		}

		vEnrollName.Format("%s", vpStrName);		
		if(FuncSaveToDB(vEnrollNumber, vBackupNumber, vPrivilege, vEnrollName)==ENROLL_SAVEDOUBLE)		
			m_strMessage.Format("Double ID : %04d",vEnrollNumber);
		else		
			m_strMessage.Format("%04d-%d", vEnrollNumber, vBackupNumber);
		m_vnPos++;
		UpdateData(FALSE);		
		MULTIPROC();
    }
    gbGetState = FALSE;    
	if(vnResultCode == RUN_SUCCESS)
		m_strMessage = "GetAllEnrollData(USB) OK";
	else
		m_strMessage = ReturnResultPrint(vnResultCode);
END:
    m_cmdGetAllEnrollDataUSB.EnableWindow(TRUE);
	UpdateData(FALSE);
	delete[] vName;
}

void CEnrollDlg::OnSetallenrollUsb() 
{
	// TODO: Add your control notification handler code here
	long vEnrollNumber, vBackupNumber, vPrivilege;
	long vnMessRet;
	BSTR vEnrollNameTemp=NULL;
	CString vEnrollName;
	CString vStr;
	CString vTitle;
	CString vstrFileName;
	long vnEnableFlag ;
	long vnResultCode;
	BOOL vbRet;
	long vnNewsKind;

	vnNewsKind = NEWS_STANDARD;
	
	CString strFilter;
	strFilter = "DAT Files (*.dat)|*.dat|All Files (*.*)|*.*";
	CFileDialog dlgOpen(TRUE, NULL, NULL, OFN_HIDEREADONLY, strFilter);
    if(dlgOpen.DoModal()==IDOK)		
		vstrFileName = dlgOpen.GetPathName();
	if (vstrFileName == "" )
		goto END;
	
	m_cmdSetAllEnrollDataUSB.EnableWindow(FALSE);	
	m_strMessage = "Working...";
	UpdateData(FALSE);
	MULTIPROC();

	gbGetState = TRUE;
	m_vnDatabaseCount= GetDatabaseCount();
	if(m_vnDatabaseCount<0)
	{
		m_strMessage = "Database Error";		
		m_cmdSetAllEnrollDataUSB.EnableWindow(TRUE);
		goto END;
	}

	m_vnPos=0;

	m_MainDlg.m_ctrlFkattend.SetUSBModel(FK625_FP2000);

	if(OpenDataBase()>=1)
	{
		while(!m_pRecordset->adoEOF)
		{
	FFF:
			vbRet = FuncReadFromToDB(&vEnrollNumber, &vBackupNumber, &vPrivilege, vEnrollName, FALSE);
			if(vbRet!=TRUE)
			{
				vStr = "SetAllEnrollData(USB) Error";
				break;
			}		
			vnEnableFlag = 1;
			vnResultCode = m_MainDlg.m_ctrlFkattend.USBGetOneEnrollData(
												  &vEnrollNumber,
												  &vBackupNumber,
												  &vPrivilege,
												  &gvpFpData[0],
												  &gvnPassWord,
												  &vnEnableFlag,
												  &vEnrollNameTemp);
			
			if(vnResultCode != RUN_SUCCESS)
			{
				vStr.Format("%s : Continue ?", ReturnResultPrint(vnResultCode));
				vnMessRet = MessageBox(vStr, "SetEnrollDataUSB",MB_YESNOCANCEL);
				if (vnMessRet == IDYES)
					goto FFF;
				else if(vnMessRet == IDCANCEL)
					break;
			}
			vEnrollName=vEnrollNameTemp;
			vnResultCode = m_MainDlg.m_ctrlFkattend.SetUserName(vEnrollNumber,(LPSTR)(LPCTSTR)vEnrollName);
			if(vnResultCode != RUN_SUCCESS)
			{
				vStr.Format("%s : Continue ?", ReturnResultPrint(vnResultCode));
				vnMessRet = MessageBox(vStr, "UserName",MB_YESNOCANCEL);
				if (vnMessRet == IDYES)
					goto FFF;
				else if(vnMessRet == IDCANCEL)
					break;
			}
			m_vnPos++;
			m_strMessage.Format("ID=%04d, FpNo=%d, Count=%d", vEnrollNumber, vBackupNumber,m_vnPos);
			MULTIPROC();
			m_pRecordset->MoveNext();
			UpdateData(FALSE);
		}
		gbGetState = FALSE;
		
		if(vnResultCode == RUN_SUCCESS)
		{
			vnResultCode = m_MainDlg.m_ctrlFkattend.USBWriteAllEnrollDataToFile( (LPSTR)(LPCTSTR)vstrFileName);
			if(vnResultCode == RUN_SUCCESS)
				m_strMessage = "USBWriteAllEnrollDataToFile OK";
			else
				m_strMessage = ReturnResultPrint(vnResultCode);
		}
		else
			m_strMessage = vStr;
	}
	else
		m_strMessage = "Database Error";
	

END:
    m_cmdSetAllEnrollDataUSB.EnableWindow(TRUE);
	UpdateData(FALSE);
}


void CEnrollDlg::OnDeltaposPositionSpin(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here
	long vnPos;
	long vnEnrollNumber;
	long vnBackupNumber;
	long vnPrivilege;
	CString vstrEnrollName;

	UpdateData(FALSE);
	vnPos=m_vnPos;
	vnPos += pNMUpDown->iDelta;
	if(m_vnDatabaseCount<=0)
		return;
	m_pRecordset->MoveFirst();
	if(vnPos <= m_vnDatabaseCount && vnPos >= 1)
	{
		m_pRecordset->Move(vnPos-1);
		FuncReadFromToDB(&vnEnrollNumber,&vnBackupNumber,&vnPrivilege,vstrEnrollName,TRUE);
		m_pRecordset->MoveNext();
		m_strDBCount.Format("%d/%d", vnPos, m_vnDatabaseCount);
		m_vnPos=vnPos;
		UpdateData(FALSE);
	}
	*pResult = 0;
}
